@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container network interface child resource.
 * @property container Reference to the container to which this container network interface is attached.
 * @property containerNetworkInterfaceConfiguration Container network interface configuration from which this container network interface is created.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipConfigurations Reference to the ip configuration on this container nic.
 * @property name The name of the resource. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the container network interface resource.
 * @property type Sub Resource type.
 */
public data class ContainerNetworkInterfaceResponse(
    public val container: ContainerResponse? = null,
    public val containerNetworkInterfaceConfiguration: ContainerNetworkInterfaceConfigurationResponse,
    public val etag: String,
    public val id: String? = null,
    public val ipConfigurations: List<ContainerNetworkInterfaceIpConfigurationResponse>,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ContainerNetworkInterfaceResponse):
            ContainerNetworkInterfaceResponse = ContainerNetworkInterfaceResponse(
            container = javaType.container().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ContainerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerNetworkInterfaceConfiguration = javaType.containerNetworkInterfaceConfiguration().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.ContainerNetworkInterfaceConfigurationResponse.Companion.toKotlin(args0)
            }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ContainerNetworkInterfaceIpConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
