@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a single Azure resource and its referencing DNS records.
 * @property dnsResources A list of dns Records
 * @property targetResource A reference to an azure resource from where the dns resource value is taken.
 */
public data class DnsResourceReferenceResponse(
    public val dnsResources: List<SubResourceResponse>? = null,
    public val targetResource: SubResourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.DnsResourceReferenceResponse):
            DnsResourceReferenceResponse = DnsResourceReferenceResponse(
            dnsResources = javaType.dnsResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            targetResource = javaType.targetResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
