@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the endpoint properties
 * @property endpoint The endpoint URL
 * @property name The name of the endpoint
 */
public data class ExperimentEndpointResponse(
    public val endpoint: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExperimentEndpointResponse):
            ExperimentEndpointResponse = ExperimentEndpointResponse(
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
