@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Contains ServiceProviderProperties in an ExpressRouteCircuit.
 * @property bandwidthInMbps The BandwidthInMbps.
 * @property peeringLocation The peering location.
 * @property serviceProviderName The serviceProviderName.
 */
public data class ExpressRouteCircuitServiceProviderPropertiesResponse(
    public val bandwidthInMbps: Int? = null,
    public val peeringLocation: String? = null,
    public val serviceProviderName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExpressRouteCircuitServiceProviderPropertiesResponse):
            ExpressRouteCircuitServiceProviderPropertiesResponse =
            ExpressRouteCircuitServiceProviderPropertiesResponse(
                bandwidthInMbps = javaType.bandwidthInMbps().map({ args0 -> args0 }).orElse(null),
                peeringLocation = javaType.peeringLocation().map({ args0 -> args0 }).orElse(null),
                serviceProviderName = javaType.serviceProviderName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
