@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Firewall Policy Insights.
 * @property isEnabled A flag to indicate if the insights are enabled on the policy.
 * @property logAnalyticsResources Workspaces needed to configure the Firewall Policy Insights.
 * @property retentionDays Number of days the insights should be enabled on the policy.
 */
public data class FirewallPolicyInsightsResponse(
    public val isEnabled: Boolean? = null,
    public val logAnalyticsResources: FirewallPolicyLogAnalyticsResourcesResponse? = null,
    public val retentionDays: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyInsightsResponse):
            FirewallPolicyInsightsResponse = FirewallPolicyInsightsResponse(
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            logAnalyticsResources = javaType.logAnalyticsResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyLogAnalyticsResourcesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionDays = javaType.retentionDays().map({ args0 -> args0 }).orElse(null),
        )
    }
}
