@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Firewall Policy NAT Rule Collection.
 * @property action The action type of a Nat rule collection.
 * @property name The name of the rule collection.
 * @property priority Priority of the Firewall Policy Rule Collection resource.
 * @property ruleCollectionType The type of the rule collection.
 * Expected value is 'FirewallPolicyNatRuleCollection'.
 * @property rules List of rules included in a rule collection.
 */
public data class FirewallPolicyNatRuleCollectionResponse(
    public val action: FirewallPolicyNatRuleCollectionActionResponse? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val ruleCollectionType: String,
    public val rules: List<Any>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyNatRuleCollectionResponse):
            FirewallPolicyNatRuleCollectionResponse = FirewallPolicyNatRuleCollectionResponse(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleCollectionActionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            ruleCollectionType = javaType.ruleCollectionType(),
            rules = javaType.rules().map({ args0 -> args0 }),
        )
    }
}
