@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress

/**
 * Configuration needed to perform TLS termination & initiation.
 * @property certificateAuthority The CA used for intermediate CA generation.
 */
public data class FirewallPolicyTransportSecurityResponse(
    public val certificateAuthority: FirewallPolicyCertificateAuthorityResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyTransportSecurityResponse):
            FirewallPolicyTransportSecurityResponse = FirewallPolicyTransportSecurityResponse(
            certificateAuthority = javaType.certificateAuthority().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyCertificateAuthorityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
