@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * GatewayCustomBgpIpAddressIpConfiguration for a virtual network gateway connection.
 * @property customBgpIpAddress The custom BgpPeeringAddress which belongs to IpconfigurationId.
 * @property ipConfigurationId The IpconfigurationId of ipconfiguration which belongs to gateway.
 */
public data class GatewayCustomBgpIpAddressIpConfigurationResponse(
    public val customBgpIpAddress: String,
    public val ipConfigurationId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GatewayCustomBgpIpAddressIpConfigurationResponse):
            GatewayCustomBgpIpAddressIpConfigurationResponse =
            GatewayCustomBgpIpAddressIpConfigurationResponse(
                customBgpIpAddress = javaType.customBgpIpAddress(),
                ipConfigurationId = javaType.ipConfigurationId(),
            )
    }
}
