@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Gateway load balancer tunnel interface of a load balancer backend address pool.
 * @property identifier Identifier of gateway load balancer tunnel interface.
 * @property port Port of gateway load balancer tunnel interface.
 * @property protocol Protocol of gateway load balancer tunnel interface.
 * @property type Traffic type of gateway load balancer tunnel interface.
 */
public data class GatewayLoadBalancerTunnelInterfaceResponse(
    public val identifier: Int? = null,
    public val port: Int? = null,
    public val protocol: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GatewayLoadBalancerTunnelInterfaceResponse):
            GatewayLoadBalancerTunnelInterfaceResponse = GatewayLoadBalancerTunnelInterfaceResponse(
            identifier = javaType.identifier().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
