@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network admin rule.
 * @property access Indicates the access allowed for this particular rule
 * @property description A description for this rule. Restricted to 140 chars.
 * @property destinationPortRanges The destination port ranges.
 * @property destinations The destination address prefixes. CIDR or destination IP ranges.
 * @property direction Indicates if the traffic matched against the rule in inbound or outbound.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property kind Whether the rule is custom or default.
 * Expected value is 'Custom'.
 * @property name Resource name.
 * @property priority The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
 * @property protocol Network protocol this rule applies to.
 * @property provisioningState The provisioning state of the resource.
 * @property resourceGuid Unique identifier for this resource.
 * @property sourcePortRanges The source port ranges.
 * @property sources The CIDR or source IP ranges.
 * @property systemData The system metadata related to this resource.
 * @property type Resource type.
 */
public data class GetAdminRuleResult(
    public val access: String,
    public val description: String? = null,
    public val destinationPortRanges: List<String>? = null,
    public val destinations: List<AddressPrefixItemResponse>? = null,
    public val direction: String,
    public val etag: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val priority: Int,
    public val protocol: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val sourcePortRanges: List<String>? = null,
    public val sources: List<AddressPrefixItemResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetAdminRuleResult):
            GetAdminRuleResult = GetAdminRuleResult(
            access = javaType.access(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationPortRanges = javaType.destinationPortRanges().map({ args0 -> args0 }),
            destinations = javaType.destinations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse.Companion.toKotlin(args0)
                })
            }),
            direction = javaType.direction(),
            etag = javaType.etag(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            priority = javaType.priority(),
            protocol = javaType.protocol(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            sourcePortRanges = javaType.sourcePortRanges().map({ args0 -> args0 }),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
