@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network security default user rule.
 * @property description A description for this rule. Restricted to 140 chars.
 * @property destinationPortRanges The destination port ranges.
 * @property destinations The destination address prefixes. CIDR or destination IP ranges.
 * @property direction Indicates if the traffic matched against the rule in inbound or outbound.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property flag Default rule flag.
 * @property id Resource ID.
 * @property kind Whether the rule is custom or default.
 * Expected value is 'Default'.
 * @property name Resource name.
 * @property protocol Network protocol this rule applies to.
 * @property provisioningState The provisioning state of the security configuration user rule resource.
 * @property sourcePortRanges The source port ranges.
 * @property sources The CIDR or source IP ranges.
 * @property systemData The system metadata related to this resource.
 * @property type Resource type.
 */
public data class GetDefaultUserRuleResult(
    public val description: String,
    public val destinationPortRanges: List<String>,
    public val destinations: List<AddressPrefixItemResponse>,
    public val direction: String,
    public val etag: String,
    public val flag: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val protocol: String,
    public val provisioningState: String,
    public val sourcePortRanges: List<String>,
    public val sources: List<AddressPrefixItemResponse>,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetDefaultUserRuleResult):
            GetDefaultUserRuleResult = GetDefaultUserRuleResult(
            description = javaType.description(),
            destinationPortRanges = javaType.destinationPortRanges().map({ args0 -> args0 }),
            destinations = javaType.destinations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse.Companion.toKotlin(args0)
                })
            }),
            direction = javaType.direction(),
            etag = javaType.etag(),
            flag = javaType.flag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            protocol = javaType.protocol(),
            provisioningState = javaType.provisioningState(),
            sourcePortRanges = javaType.sourcePortRanges().map({ args0 -> args0 }),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressPrefixItemResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
