@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * ExpressRoute gateway resource.
 * @property allowNonVirtualWanTraffic Configures this gateway to accept traffic from non Virtual WAN networks.
 * @property autoScaleConfiguration Configuration for auto scaling.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property expressRouteConnections List of ExpressRoute connections to the ExpressRoute gateway.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the express route gateway resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualHub The Virtual Hub where the ExpressRoute gateway is or will be deployed.
 */
public data class GetExpressRouteGatewayResult(
    public val allowNonVirtualWanTraffic: Boolean? = null,
    public val autoScaleConfiguration: ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration? =
        null,
    public val etag: String,
    public val expressRouteConnections: List<ExpressRouteConnectionResponse>? = null,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualHub: VirtualHubIdResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetExpressRouteGatewayResult):
            GetExpressRouteGatewayResult = GetExpressRouteGatewayResult(
            allowNonVirtualWanTraffic = javaType.allowNonVirtualWanTraffic().map({ args0 ->
                args0
            }).orElse(null),
            autoScaleConfiguration = javaType.autoScaleConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            expressRouteConnections = javaType.expressRouteConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualHub = javaType.virtualHub().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.VirtualHubIdResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
