@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * ExpressRoutePort resource definition.
 * @property allocationDate Date of the physical port allocation to be used in Letter of Authorization.
 * @property bandwidthInGbps Bandwidth of procured ports in Gbps.
 * @property billingType The billing type of the ExpressRoutePort resource.
 * @property circuits Reference the ExpressRoute circuit(s) that are provisioned on this ExpressRoutePort resource.
 * @property encapsulation Encapsulation method on physical ports.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property etherType Ether type of the physical port.
 * @property id Resource ID.
 * @property identity The identity of ExpressRoutePort, if configured.
 * @property links The set of physical links of the ExpressRoutePort resource.
 * @property location Resource location.
 * @property mtu Maximum transmission unit of the physical port pair(s).
 * @property name Resource name.
 * @property peeringLocation The name of the peering location that the ExpressRoutePort is mapped to physically.
 * @property provisionedBandwidthInGbps Aggregate Gbps of associated circuit bandwidths.
 * @property provisioningState The provisioning state of the express route port resource.
 * @property resourceGuid The resource GUID property of the express route port resource.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetExpressRoutePortResult(
    public val allocationDate: String,
    public val bandwidthInGbps: Int? = null,
    public val billingType: String? = null,
    public val circuits: List<SubResourceResponse>,
    public val encapsulation: String? = null,
    public val etag: String,
    public val etherType: String,
    public val id: String? = null,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val links: List<ExpressRouteLinkResponse>? = null,
    public val location: String? = null,
    public val mtu: String,
    public val name: String,
    public val peeringLocation: String? = null,
    public val provisionedBandwidthInGbps: Double,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetExpressRoutePortResult):
            GetExpressRoutePortResult = GetExpressRoutePortResult(
            allocationDate = javaType.allocationDate(),
            bandwidthInGbps = javaType.bandwidthInGbps().map({ args0 -> args0 }).orElse(null),
            billingType = javaType.billingType().map({ args0 -> args0 }).orElse(null),
            circuits = javaType.circuits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            encapsulation = javaType.encapsulation().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            etherType = javaType.etherType(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            links = javaType.links().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteLinkResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            mtu = javaType.mtu(),
            name = javaType.name(),
            peeringLocation = javaType.peeringLocation().map({ args0 -> args0 }).orElse(null),
            provisionedBandwidthInGbps = javaType.provisionedBandwidthInGbps(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
