@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a forwarding rule within a DNS forwarding ruleset.
 * @property domainName The domain name for the forwarding rule.
 * @property etag ETag of the forwarding rule.
 * @property forwardingRuleState The state of forwarding rule.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property metadata Metadata attached to the forwarding rule.
 * @property name The name of the resource
 * @property provisioningState The current provisioning state of the forwarding rule. This is a read-only property and any attempt to set this value will be ignored.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property targetDnsServers DNS servers to forward the DNS query to.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetForwardingRuleResult(
    public val domainName: String,
    public val etag: String,
    public val forwardingRuleState: String? = null,
    public val id: String,
    public val metadata: Map<String, String>? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val targetDnsServers: List<TargetDnsServerResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetForwardingRuleResult):
            GetForwardingRuleResult = GetForwardingRuleResult(
            domainName = javaType.domainName(),
            etag = javaType.etag(),
            forwardingRuleState = javaType.forwardingRuleState().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetDnsServers = javaType.targetDnsServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.TargetDnsServerResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
