@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Nat Gateway resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The idle timeout of the nat gateway.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the NAT gateway resource.
 * @property publicIpAddresses An array of public ip addresses associated with the nat gateway resource.
 * @property publicIpPrefixes An array of public ip prefixes associated with the nat gateway resource.
 * @property resourceGuid The resource GUID property of the NAT gateway resource.
 * @property sku The nat gateway SKU.
 * @property subnets An array of references to the subnets using this nat gateway resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property zones A list of availability zones denoting the zone in which Nat Gateway should be deployed.
 */
public data class GetNatGatewayResult(
    public val etag: String,
    public val id: String? = null,
    public val idleTimeoutInMinutes: Int? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val publicIpAddresses: List<SubResourceResponse>? = null,
    public val publicIpPrefixes: List<SubResourceResponse>? = null,
    public val resourceGuid: String,
    public val sku: NatGatewaySkuResponse? = null,
    public val subnets: List<SubResourceResponse>,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNatGatewayResult):
            GetNatGatewayResult = GetNatGatewayResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            idleTimeoutInMinutes = javaType.idleTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publicIpAddresses = javaType.publicIpAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            publicIpPrefixes = javaType.publicIpPrefixes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            resourceGuid = javaType.resourceGuid(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NatGatewaySkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
