@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS zone.
 * @property aRecords The list of A records in the record set.
 * @property aaaaRecords The list of AAAA records in the record set.
 * @property cnameRecord The CNAME record in the record set.
 * @property etag The ETag of the record set.
 * @property fqdn Fully qualified domain name of the record set.
 * @property id Fully qualified resource Id for the resource. Example - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
 * @property isAutoRegistered Is the record set auto-registered in the Private DNS zone through a virtual network link?
 * @property metadata The metadata attached to the record set.
 * @property mxRecords The list of MX records in the record set.
 * @property name The name of the resource
 * @property ptrRecords The list of PTR records in the record set.
 * @property soaRecord The SOA record in the record set.
 * @property srvRecords The list of SRV records in the record set.
 * @property ttl The TTL (time-to-live) of the records in the record set.
 * @property txtRecords The list of TXT records in the record set.
 * @property type The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
 */
public data class GetPrivateRecordSetResult(
    public val aRecords: List<ARecordResponse>? = null,
    public val aaaaRecords: List<AaaaRecordResponse>? = null,
    public val cnameRecord: CnameRecordResponse? = null,
    public val etag: String? = null,
    public val fqdn: String,
    public val id: String,
    public val isAutoRegistered: Boolean,
    public val metadata: Map<String, String>? = null,
    public val mxRecords: List<MxRecordResponse>? = null,
    public val name: String,
    public val ptrRecords: List<PtrRecordResponse>? = null,
    public val soaRecord: SoaRecordResponse? = null,
    public val srvRecords: List<SrvRecordResponse>? = null,
    public val ttl: Double? = null,
    public val txtRecords: List<TxtRecordResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPrivateRecordSetResult):
            GetPrivateRecordSetResult = GetPrivateRecordSetResult(
            aRecords = javaType.aRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ARecordResponse.Companion.toKotlin(args0)
                })
            }),
            aaaaRecords = javaType.aaaaRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AaaaRecordResponse.Companion.toKotlin(args0)
                })
            }),
            cnameRecord = javaType.cnameRecord().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.CnameRecordResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            fqdn = javaType.fqdn(),
            id = javaType.id(),
            isAutoRegistered = javaType.isAutoRegistered(),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            mxRecords = javaType.mxRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.MxRecordResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            ptrRecords = javaType.ptrRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PtrRecordResponse.Companion.toKotlin(args0)
                })
            }),
            soaRecord = javaType.soaRecord().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SoaRecordResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            srvRecords = javaType.srvRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SrvRecordResponse.Companion.toKotlin(args0)
                })
            }),
            ttl = javaType.ttl().map({ args0 -> args0 }).orElse(null),
            txtRecords = javaType.txtRecords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.TxtRecordResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
