@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Route table resource.
 * @property disableBgpRoutePropagation Whether to disable the routes learned by BGP on that route table. True means disable.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the route table resource.
 * @property resourceGuid The resource GUID property of the route table.
 * @property routes Collection of routes contained within a route table.
 * @property subnets A collection of references to subnets.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetRouteTableResult(
    public val disableBgpRoutePropagation: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val routes: List<RouteResponse>? = null,
    public val subnets: List<SubnetResponse>,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetRouteTableResult):
            GetRouteTableResult = GetRouteTableResult(
            disableBgpRoutePropagation = javaType.disableBgpRoutePropagation().map({ args0 ->
                args0
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RouteResponse.Companion.toKotlin(args0)
                })
            }),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
