@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Scope Connections resource
 * @property description A description of the scope connection.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Resource name.
 * @property resourceId Resource ID.
 * @property systemData The system metadata related to this resource.
 * @property tenantId Tenant ID.
 * @property type Resource type.
 */
public data class GetScopeConnectionResult(
    public val description: String? = null,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val resourceId: String? = null,
    public val systemData: SystemDataResponse,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetScopeConnectionResult):
            GetScopeConnectionResult = GetScopeConnectionResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
