@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the security admin configuration
 * @property applyOnNetworkIntentPolicyBasedServices Enum list of network intent policy based services.
 * @property description A description of the security configuration.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the resource.
 * @property resourceGuid Unique identifier for this resource.
 * @property systemData The system metadata related to this resource.
 * @property type Resource type.
 */
public data class GetSecurityAdminConfigurationResult(
    public val applyOnNetworkIntentPolicyBasedServices: List<String>? = null,
    public val description: String? = null,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetSecurityAdminConfigurationResult):
            GetSecurityAdminConfigurationResult = GetSecurityAdminConfigurationResult(
            applyOnNetworkIntentPolicyBasedServices = javaType.applyOnNetworkIntentPolicyBasedServices().map({ args0 ->
                args0
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
