@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network security rule.
 * @property access The network traffic is allowed or denied.
 * @property description A description for this rule. Restricted to 140 chars.
 * @property destinationAddressPrefix The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
 * @property destinationAddressPrefixes The destination address prefixes. CIDR or destination IP ranges.
 * @property destinationApplicationSecurityGroups The application security group specified as destination.
 * @property destinationPortRange The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property destinationPortRanges The destination port ranges.
 * @property direction The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property priority The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
 * @property protocol Network protocol this rule applies to.
 * @property provisioningState The provisioning state of the security rule resource.
 * @property sourceAddressPrefix The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
 * @property sourceAddressPrefixes The CIDR or source IP ranges.
 * @property sourceApplicationSecurityGroups The application security group specified as source.
 * @property sourcePortRange The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
 * @property sourcePortRanges The source port ranges.
 * @property type The type of the resource.
 */
public data class GetSecurityRuleResult(
    public val access: String,
    public val description: String? = null,
    public val destinationAddressPrefix: String? = null,
    public val destinationAddressPrefixes: List<String>? = null,
    public val destinationApplicationSecurityGroups: List<ApplicationSecurityGroupResponse>? = null,
    public val destinationPortRange: String? = null,
    public val destinationPortRanges: List<String>? = null,
    public val direction: String,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val priority: Int,
    public val protocol: String,
    public val provisioningState: String,
    public val sourceAddressPrefix: String? = null,
    public val sourceAddressPrefixes: List<String>? = null,
    public val sourceApplicationSecurityGroups: List<ApplicationSecurityGroupResponse>? = null,
    public val sourcePortRange: String? = null,
    public val sourcePortRanges: List<String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetSecurityRuleResult):
            GetSecurityRuleResult = GetSecurityRuleResult(
            access = javaType.access(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddressPrefix = javaType.destinationAddressPrefix().map({ args0 -> args0 }).orElse(null),
            destinationAddressPrefixes = javaType.destinationAddressPrefixes().map({ args0 -> args0 }),
            destinationApplicationSecurityGroups = javaType.destinationApplicationSecurityGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationSecurityGroupResponse.Companion.toKotlin(args0)
                })
            }),
            destinationPortRange = javaType.destinationPortRange().map({ args0 -> args0 }).orElse(null),
            destinationPortRanges = javaType.destinationPortRanges().map({ args0 -> args0 }),
            direction = javaType.direction(),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority(),
            protocol = javaType.protocol(),
            provisioningState = javaType.provisioningState(),
            sourceAddressPrefix = javaType.sourceAddressPrefix().map({ args0 -> args0 }).orElse(null),
            sourceAddressPrefixes = javaType.sourceAddressPrefixes().map({ args0 -> args0 }),
            sourceApplicationSecurityGroups = javaType.sourceApplicationSecurityGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationSecurityGroupResponse.Companion.toKotlin(args0)
                })
            }),
            sourcePortRange = javaType.sourcePortRange().map({ args0 -> args0 }).orElse(null),
            sourcePortRanges = javaType.sourcePortRanges().map({ args0 -> args0 }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
