@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * StaticMember Item.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the scope assignment resource.
 * @property region Resource region.
 * @property resourceId Resource Id.
 * @property systemData The system metadata related to this resource.
 * @property type Resource type.
 */
public data class GetStaticMemberResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val region: String,
    public val resourceId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetStaticMemberResult):
            GetStaticMemberResult = GetStaticMemberResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            region = javaType.region(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
