@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Virtual Router Peering resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the virtual router peering that is unique within a virtual router.
 * @property peerAsn Peer ASN.
 * @property peerIp Peer IP.
 * @property provisioningState The provisioning state of the resource.
 * @property type Peering type.
 */
public data class GetVirtualRouterPeeringResult(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val peerAsn: Double? = null,
    public val peerIp: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualRouterPeeringResult):
            GetVirtualRouterPeeringResult = GetVirtualRouterPeeringResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            peerAsn = javaType.peerAsn().map({ args0 -> args0 }).orElse(null),
            peerIp = javaType.peerIp().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
