@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * VpnSite Resource.
 * @property addressSpace The AddressSpace that contains an array of IP address ranges.
 * @property bgpProperties The set of bgp properties.
 * @property deviceProperties The device properties.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipAddress The ip-address for the vpn-site.
 * @property isSecuritySite IsSecuritySite flag.
 * @property location Resource location.
 * @property name Resource name.
 * @property o365Policy Office365 Policy.
 * @property provisioningState The provisioning state of the VPN site resource.
 * @property siteKey The key for vpn-site that can be used for connections.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualWan The VirtualWAN to which the vpnSite belongs.
 * @property vpnSiteLinks List of all vpn site links.
 */
public data class GetVpnSiteResult(
    public val addressSpace: AddressSpaceResponse? = null,
    public val bgpProperties: BgpSettingsResponse? = null,
    public val deviceProperties: DevicePropertiesResponse? = null,
    public val etag: String,
    public val id: String? = null,
    public val ipAddress: String? = null,
    public val isSecuritySite: Boolean? = null,
    public val location: String,
    public val name: String,
    public val o365Policy: O365PolicyPropertiesResponse? = null,
    public val provisioningState: String,
    public val siteKey: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualWan: SubResourceResponse? = null,
    public val vpnSiteLinks: List<VpnSiteLinkResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVpnSiteResult):
            GetVpnSiteResult = GetVpnSiteResult(
            addressSpace = javaType.addressSpace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bgpProperties = javaType.bgpProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deviceProperties = javaType.deviceProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.DevicePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            isSecuritySite = javaType.isSecuritySite().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            o365Policy = javaType.o365Policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.O365PolicyPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            siteKey = javaType.siteKey().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualWan = javaType.virtualWan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vpnSiteLinks = javaType.vpnSiteLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnSiteLinkResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
