@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Public IP addresses associated with azure firewall.
 * @property addresses The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
 * @property count The number of Public IP addresses associated with azure firewall.
 */
public data class HubPublicIPAddressesResponse(
    public val addresses: List<AzureFirewallPublicIPAddressResponse>? = null,
    public val count: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.HubPublicIPAddressesResponse):
            HubPublicIPAddressesResponse = HubPublicIPAddressesResponse(
            addresses = javaType.addresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallPublicIPAddressResponse.Companion.toKotlin(args0)
                })
            }),
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
        )
    }
}
