@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The response to an enumeration operation on Virtual Network DNS Forwarding Ruleset.
 * @property nextLink The continuation token for the next page of results.
 * @property value Enumeration of the Virtual Network DNS Forwarding Ruleset.
 */
public data class ListDnsForwardingRulesetByVirtualNetworkResult(
    public val nextLink: String,
    public val `value`: List<VirtualNetworkDnsForwardingRulesetResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ListDnsForwardingRulesetByVirtualNetworkResult):
            ListDnsForwardingRulesetByVirtualNetworkResult =
            ListDnsForwardingRulesetByVirtualNetworkResult(
                nextLink = javaType.nextLink(),
                `value` = javaType.`value`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkDnsForwardingRulesetResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
