@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Result of the request to list networkManagerEffectiveConnectivityConfiguration. It contains a list of groups and a skiptoken to get the next set of results.
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 * @property value Gets a page of NetworkManagerEffectiveConnectivityConfiguration
 */
public data class ListNetworkManagerEffectiveConnectivityConfigurationsResult(
    public val skipToken: String? = null,
    public val `value`: List<EffectiveConnectivityConfigurationResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ListNetworkManagerEffectiveConnectivityConfigurationsResult):
            ListNetworkManagerEffectiveConnectivityConfigurationsResult =
            ListNetworkManagerEffectiveConnectivityConfigurationsResult(
                skipToken = javaType.skipToken().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.EffectiveConnectivityConfigurationResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
