@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Allow to exclude some variable satisfy the condition for the WAF check.
 * @property exclusions The Exclusions that are applied on the policy.
 * @property managedRuleSets The managed rule sets that are associated with the policy.
 */
public data class ManagedRulesDefinitionResponse(
    public val exclusions: List<OwaspCrsExclusionEntryResponse>? = null,
    public val managedRuleSets: List<ManagedRuleSetResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ManagedRulesDefinitionResponse):
            ManagedRulesDefinitionResponse = ManagedRulesDefinitionResponse(
            exclusions = javaType.exclusions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.OwaspCrsExclusionEntryResponse.Companion.toKotlin(args0)
                })
            }),
            managedRuleSets = javaType.managedRuleSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleSetResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
