@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rule of type nat.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property destinationPorts List of destination ports.
 * @property ipProtocols Array of FirewallPolicyRuleNetworkProtocols.
 * @property name Name of the rule.
 * @property ruleType Rule Type.
 * Expected value is 'NatRule'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property translatedAddress The translated address for this NAT rule.
 * @property translatedFqdn The translated FQDN for this NAT rule.
 * @property translatedPort The translated port for this NAT rule.
 */
public data class NatRuleResponse(
    public val description: String? = null,
    public val destinationAddresses: List<String>? = null,
    public val destinationPorts: List<String>? = null,
    public val ipProtocols: List<String>? = null,
    public val name: String? = null,
    public val ruleType: String,
    public val sourceAddresses: List<String>? = null,
    public val sourceIpGroups: List<String>? = null,
    public val translatedAddress: String? = null,
    public val translatedFqdn: String? = null,
    public val translatedPort: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NatRuleResponse):
            NatRuleResponse = NatRuleResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
            destinationPorts = javaType.destinationPorts().map({ args0 -> args0 }),
            ipProtocols = javaType.ipProtocols().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ruleType = javaType.ruleType(),
            sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
            sourceIpGroups = javaType.sourceIpGroups().map({ args0 -> args0 }),
            translatedAddress = javaType.translatedAddress().map({ args0 -> args0 }).orElse(null),
            translatedFqdn = javaType.translatedFqdn().map({ args0 -> args0 }).orElse(null),
            translatedPort = javaType.translatedPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
