@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DNS settings of a network interface.
 * @property appliedDnsServers If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
 * @property dnsServers List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
 * @property internalDnsNameLabel Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
 * @property internalDomainNameSuffix Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
 * @property internalFqdn Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
 */
public data class NetworkInterfaceDnsSettingsResponse(
    public val appliedDnsServers: List<String>,
    public val dnsServers: List<String>? = null,
    public val internalDnsNameLabel: String? = null,
    public val internalDomainNameSuffix: String,
    public val internalFqdn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NetworkInterfaceDnsSettingsResponse):
            NetworkInterfaceDnsSettingsResponse = NetworkInterfaceDnsSettingsResponse(
            appliedDnsServers = javaType.appliedDnsServers().map({ args0 -> args0 }),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            internalDnsNameLabel = javaType.internalDnsNameLabel().map({ args0 -> args0 }).orElse(null),
            internalDomainNameSuffix = javaType.internalDomainNameSuffix(),
            internalFqdn = javaType.internalFqdn(),
        )
    }
}
