@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Scope of Network Manager.
 * @property crossTenantScopes List of cross tenant scopes.
 * @property managementGroups List of management groups.
 * @property subscriptions List of subscriptions.
 */
public data class NetworkManagerPropertiesResponseNetworkManagerScopes(
    public val crossTenantScopes: List<CrossTenantScopesResponse>,
    public val managementGroups: List<String>? = null,
    public val subscriptions: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NetworkManagerPropertiesResponseNetworkManagerScopes):
            NetworkManagerPropertiesResponseNetworkManagerScopes =
            NetworkManagerPropertiesResponseNetworkManagerScopes(
                crossTenantScopes = javaType.crossTenantScopes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.CrossTenantScopesResponse.Companion.toKotlin(args0)
                    })
                }),
                managementGroups = javaType.managementGroups().map({ args0 -> args0 }),
                subscriptions = javaType.subscriptions().map({ args0 -> args0 }),
            )
    }
}
