@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A load balancer probe.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property intervalInSeconds The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
 * @property loadBalancingRules The load balancer rules that use this probe.
 * @property name The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.
 * @property numberOfProbes The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
 * @property port The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
 * @property probeThreshold The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint. After failing the number of consecutive probes equal to this value, the endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in rotation.
 * @property protocol The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
 * @property provisioningState The provisioning state of the probe resource.
 * @property requestPath The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
 * @property type Type of the resource.
 */
public data class ProbeResponse(
    public val etag: String,
    public val id: String? = null,
    public val intervalInSeconds: Int? = null,
    public val loadBalancingRules: List<SubResourceResponse>,
    public val name: String? = null,
    public val numberOfProbes: Int? = null,
    public val port: Int,
    public val probeThreshold: Int? = null,
    public val protocol: String,
    public val provisioningState: String,
    public val requestPath: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ProbeResponse):
            ProbeResponse = ProbeResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            intervalInSeconds = javaType.intervalInSeconds().map({ args0 -> args0 }).orElse(null),
            loadBalancingRules = javaType.loadBalancingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            numberOfProbes = javaType.numberOfProbes().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
            probeThreshold = javaType.probeThreshold().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
            provisioningState = javaType.provisioningState(),
            requestPath = javaType.requestPath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
