@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SKU of a public IP address.
 * @property name Name of a public IP address SKU.
 * @property tier Tier of a public IP address SKU.
 */
public data class PublicIPAddressSkuResponse(
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PublicIPAddressSkuResponse):
            PublicIPAddressSkuResponse = PublicIPAddressSkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
