@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SKU of a public IP prefix.
 * @property name Name of a public IP prefix SKU.
 * @property tier Tier of a public IP prefix SKU.
 */
public data class PublicIPPrefixSkuResponse(
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PublicIPPrefixSkuResponse):
            PublicIPPrefixSkuResponse = PublicIPPrefixSkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
