@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
 * @property regionalCommunity The BGP community associated with the region of the virtual network.
 * @property virtualNetworkCommunity The BGP community associated with the virtual network.
 */
public data class VirtualNetworkBgpCommunitiesResponse(
    public val regionalCommunity: String,
    public val virtualNetworkCommunity: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualNetworkBgpCommunitiesResponse):
            VirtualNetworkBgpCommunitiesResponse = VirtualNetworkBgpCommunitiesResponse(
            regionalCommunity = javaType.regionalCommunity(),
            virtualNetworkCommunity = javaType.virtualNetworkCommunity(),
        )
    }
}
