@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Parameters for VirtualNetworkGatewayPolicyGroup.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property isDefault Shows if this is a Default VirtualNetworkGatewayPolicyGroup or not.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property policyMembers Multiple PolicyMembers for VirtualNetworkGatewayPolicyGroup.
 * @property priority Priority for VirtualNetworkGatewayPolicyGroup.
 * @property provisioningState The provisioning state of the VirtualNetworkGatewayPolicyGroup resource.
 * @property vngClientConnectionConfigurations List of references to vngClientConnectionConfigurations.
 */
public data class VirtualNetworkGatewayPolicyGroupResponse(
    public val etag: String,
    public val id: String? = null,
    public val isDefault: Boolean,
    public val name: String? = null,
    public val policyMembers: List<VirtualNetworkGatewayPolicyGroupMemberResponse>,
    public val priority: Int,
    public val provisioningState: String,
    public val vngClientConnectionConfigurations: List<SubResourceResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualNetworkGatewayPolicyGroupResponse):
            VirtualNetworkGatewayPolicyGroupResponse = VirtualNetworkGatewayPolicyGroupResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            isDefault = javaType.isDefault(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            policyMembers = javaType.policyMembers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkGatewayPolicyGroupMemberResponse.Companion.toKotlin(args0)
                })
            }),
            priority = javaType.priority(),
            provisioningState = javaType.provisioningState(),
            vngClientConnectionConfigurations = javaType.vngClientConnectionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
