@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP Configuration of a VPN Gateway Resource.
 * @property id The identifier of the IP configuration for a VPN Gateway.
 * @property privateIpAddress The private IP address of this IP configuration.
 * @property publicIpAddress The public IP address of this IP configuration.
 */
public data class VpnGatewayIpConfigurationResponse(
    public val id: String? = null,
    public val privateIpAddress: String? = null,
    public val publicIpAddress: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnGatewayIpConfigurationResponse):
            VpnGatewayIpConfigurationResponse = VpnGatewayIpConfigurationResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
            publicIpAddress = javaType.publicIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
