@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VpnServerConfiguration PolicyGroup member
 * @property attributeType The Vpn Policy member attribute type.
 * @property attributeValue The value of Attribute used for this VpnServerConfigurationPolicyGroupMember.
 * @property name Name of the VpnServerConfigurationPolicyGroupMember.
 */
public data class VpnServerConfigurationPolicyGroupMemberResponse(
    public val attributeType: String? = null,
    public val attributeValue: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnServerConfigurationPolicyGroupMemberResponse):
            VpnServerConfigurationPolicyGroupMemberResponse =
            VpnServerConfigurationPolicyGroupMemberResponse(
                attributeType = javaType.attributeType().map({ args0 -> args0 }).orElse(null),
                attributeValue = javaType.attributeValue().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
