@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.inputs

import com.pulumi.azurenative.networkanalytics.inputs.ListDataProductRolesAssignmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataProductName The data product resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListDataProductRolesAssignmentsPlainArgs(
    public val dataProductName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkanalytics.inputs.ListDataProductRolesAssignmentsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkanalytics.inputs.ListDataProductRolesAssignmentsPlainArgs =
        com.pulumi.azurenative.networkanalytics.inputs.ListDataProductRolesAssignmentsPlainArgs.builder()
            .dataProductName(dataProductName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListDataProductRolesAssignmentsPlainArgs].
 */
@PulumiTagMarker
public class ListDataProductRolesAssignmentsPlainArgsBuilder internal constructor() {
    private var dataProductName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The data product resource name
     */
    @JvmName("hadtrbdeamjjpbka")
    public suspend fun dataProductName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataProductName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tsignrhkjxailchq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListDataProductRolesAssignmentsPlainArgs =
        ListDataProductRolesAssignmentsPlainArgs(
            dataProductName = dataProductName ?: throw PulumiNullFieldException("dataProductName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
