@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.ConsoleArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.ConsoleEnabled
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.SshPublicKeyArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.SshPublicKeyArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update virtual machine console
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var console = new AzureNative.NetworkCloud.Console("console", new()
 *     {
 *         ConsoleName = "default",
 *         Enabled = "True",
 *         Expiration = "2022-06-01T01:27:03.008Z",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterManagerExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         SshPublicKey = new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *         {
 *             KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *         },
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         VirtualMachineName = "virtualMachineName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewConsole(ctx, "console", &networkcloud.ConsoleArgs{
 * 			ConsoleName: pulumi.String("default"),
 * 			Enabled:     pulumi.String("True"),
 * 			Expiration:  pulumi.String("2022-06-01T01:27:03.008Z"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterManagerExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SshPublicKey: &networkcloud.SshPublicKeyArgs{
 * 				KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			VirtualMachineName: pulumi.String("virtualMachineName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.Console;
 * import com.pulumi.azurenative.networkcloud.ConsoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var console = new Console("console", ConsoleArgs.builder()
 *             .consoleName("default")
 *             .enabled("True")
 *             .expiration("2022-06-01T01:27:03.008Z")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterManagerExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .sshPublicKey(Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .virtualMachineName("virtualMachineName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:Console default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}
 * ```
 * @property consoleName The name of the virtual machine console.
 * @property enabled The indicator of whether the console access is enabled.
 * @property expiration The date and time after which the key will be disallowed access.
 * @property extendedLocation The extended location of the cluster manager associated with the cluster this virtual machine is created on.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sshPublicKey The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
 * @property tags Resource tags.
 * @property virtualMachineName The name of the virtual machine.
 */
public data class ConsoleArgs(
    public val consoleName: Output<String>? = null,
    public val enabled: Output<Either<String, ConsoleEnabled>>? = null,
    public val expiration: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sshPublicKey: Output<SshPublicKeyArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualMachineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.ConsoleArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.ConsoleArgs =
        com.pulumi.azurenative.networkcloud.ConsoleArgs.builder()
            .consoleName(consoleName?.applyValue({ args0 -> args0 }))
            .enabled(
                enabled?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .expiration(expiration?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sshPublicKey(sshPublicKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConsoleArgs].
 */
@PulumiTagMarker
public class ConsoleArgsBuilder internal constructor() {
    private var consoleName: Output<String>? = null

    private var enabled: Output<Either<String, ConsoleEnabled>>? = null

    private var expiration: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sshPublicKey: Output<SshPublicKeyArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualMachineName: Output<String>? = null

    /**
     * @param value The name of the virtual machine console.
     */
    @JvmName("lhkgbywkxnbyytxk")
    public suspend fun consoleName(`value`: Output<String>) {
        this.consoleName = value
    }

    /**
     * @param value The indicator of whether the console access is enabled.
     */
    @JvmName("epvojntwnoplfnjx")
    public suspend fun enabled(`value`: Output<Either<String, ConsoleEnabled>>) {
        this.enabled = value
    }

    /**
     * @param value The date and time after which the key will be disallowed access.
     */
    @JvmName("rvjcnvgmemnaqlpd")
    public suspend fun expiration(`value`: Output<String>) {
        this.expiration = value
    }

    /**
     * @param value The extended location of the cluster manager associated with the cluster this virtual machine is created on.
     */
    @JvmName("uxtqjvjxbtpqvmui")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("iaqklnupkufcyaep")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iivjljoxtglbtwlb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
     */
    @JvmName("sdvuonbircnjnyww")
    public suspend fun sshPublicKey(`value`: Output<SshPublicKeyArgs>) {
        this.sshPublicKey = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ookilrimsdoduirr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("gqrkaxhmmhjxsdkf")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value The name of the virtual machine console.
     */
    @JvmName("gmtwaavqkkxvmkkl")
    public suspend fun consoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consoleName = mapped
    }

    /**
     * @param value The indicator of whether the console access is enabled.
     */
    @JvmName("fnjpctoxaklvbubg")
    public suspend fun enabled(`value`: Either<String, ConsoleEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The indicator of whether the console access is enabled.
     */
    @JvmName("bbiejynfuknkoatk")
    public fun enabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConsoleEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The indicator of whether the console access is enabled.
     */
    @JvmName("pediouduonjswlqq")
    public fun enabled(`value`: ConsoleEnabled) {
        val toBeMapped = Either.ofRight<String, ConsoleEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The date and time after which the key will be disallowed access.
     */
    @JvmName("fwdhbfodbsuvmfpu")
    public suspend fun expiration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiration = mapped
    }

    /**
     * @param value The extended location of the cluster manager associated with the cluster this virtual machine is created on.
     */
    @JvmName("dqsocurwjyeulnnh")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster manager associated with the cluster this virtual machine is created on.
     */
    @JvmName("slpncbleovelbxad")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mthednvhxixogtac")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vxcaicnvyxewgnlw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
     */
    @JvmName("soidmdbybfmjmkys")
    public suspend fun sshPublicKey(`value`: SshPublicKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPublicKey = mapped
    }

    /**
     * @param argument The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
     */
    @JvmName("mqjtchswgqvjyoiy")
    public suspend fun sshPublicKey(argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = SshPublicKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sshPublicKey = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ixwobjpiatomedsh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vetttjhmycioiscw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("dbhllljgbgpfgxab")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    internal fun build(): ConsoleArgs = ConsoleArgs(
        consoleName = consoleName,
        enabled = enabled,
        expiration = expiration,
        extendedLocation = extendedLocation,
        location = location,
        resourceGroupName = resourceGroupName,
        sshPublicKey = sshPublicKey,
        tags = tags,
        virtualMachineName = virtualMachineName,
    )
}
