@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.KubernetesClusterArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AadConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AadConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministratorConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministratorConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ControlPlaneNodeConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ControlPlaneNodeConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.InitialAgentPoolConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.InitialAgentPoolConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ManagedResourceGroupConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ManagedResourceGroupConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.NetworkConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.NetworkConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update Kubernetes cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kubernetesCluster = new AzureNative.NetworkCloud.KubernetesCluster("kubernetesCluster", new()
 *     {
 *         AadConfiguration = new AzureNative.NetworkCloud.Inputs.AadConfigurationArgs
 *         {
 *             AdminGroupObjectIds = new[]
 *             {
 *                 "ffffffff-ffff-ffff-ffff-ffffffffffff",
 *             },
 *         },
 *         AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *         {
 *             AdminUsername = "azure",
 *             SshPublicKeys = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *             },
 *         },
 *         ControlPlaneNodeConfiguration = new AzureNative.NetworkCloud.Inputs.ControlPlaneNodeConfigurationArgs
 *         {
 *             AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *             {
 *                 AdminUsername = "azure",
 *                 SshPublicKeys = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                     {
 *                         KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                     },
 *                 },
 *             },
 *             AvailabilityZones = new[]
 *             {
 *                 "1",
 *                 "2",
 *                 "3",
 *             },
 *             Count = 3,
 *             VmSkuName = "NC_G4_v1",
 *         },
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         InitialAgentPoolConfigurations = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.InitialAgentPoolConfigurationArgs
 *             {
 *                 AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *                 {
 *                     AdminUsername = "azure",
 *                     SshPublicKeys = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                         {
 *                             KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                         },
 *                     },
 *                 },
 *                 AgentOptions = new AzureNative.NetworkCloud.Inputs.AgentOptionsArgs
 *                 {
 *                     HugepagesCount = 96,
 *                     HugepagesSize = "1G",
 *                 },
 *                 AttachedNetworkConfiguration = new AzureNative.NetworkCloud.Inputs.AttachedNetworkConfigurationArgs
 *                 {
 *                     L2Networks = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.L2NetworkAttachmentConfigurationArgs
 *                         {
 *                             NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName",
 *                             PluginType = "DPDK",
 *                         },
 *                     },
 *                     L3Networks = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.L3NetworkAttachmentConfigurationArgs
 *                         {
 *                             IpamEnabled = "False",
 *                             NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                             PluginType = "SRIOV",
 *                         },
 *                     },
 *                     TrunkedNetworks = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.TrunkedNetworkAttachmentConfigurationArgs
 *                         {
 *                             NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName",
 *                             PluginType = "MACVLAN",
 *                         },
 *                     },
 *                 },
 *                 AvailabilityZones = new[]
 *                 {
 *                     "1",
 *                     "2",
 *                     "3",
 *                 },
 *                 Count = 3,
 *                 Labels = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *                     {
 *                         Key = "kubernetes.label",
 *                         Value = "true",
 *                     },
 *                 },
 *                 Mode = "System",
 *                 Name = "SystemPool-1",
 *                 Taints = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *                     {
 *                         Key = "kubernetes.taint",
 *                         Value = "true",
 *                     },
 *                 },
 *                 UpgradeSettings = new AzureNative.NetworkCloud.Inputs.AgentPoolUpgradeSettingsArgs
 *                 {
 *                     MaxSurge = "1",
 *                 },
 *                 VmSkuName = "NC_M16_v1",
 *             },
 *         },
 *         KubernetesClusterName = "kubernetesClusterName",
 *         KubernetesVersion = "1.24.12-1",
 *         Location = "location",
 *         ManagedResourceGroupConfiguration = new AzureNative.NetworkCloud.Inputs.ManagedResourceGroupConfigurationArgs
 *         {
 *             Location = "East US",
 *             Name = "my-managed-rg",
 *         },
 *         NetworkConfiguration = new AzureNative.NetworkCloud.Inputs.NetworkConfigurationArgs
 *         {
 *             AttachedNetworkConfiguration = new AzureNative.NetworkCloud.Inputs.AttachedNetworkConfigurationArgs
 *             {
 *                 L2Networks = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.L2NetworkAttachmentConfigurationArgs
 *                     {
 *                         NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName",
 *                         PluginType = "DPDK",
 *                     },
 *                 },
 *                 L3Networks = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.L3NetworkAttachmentConfigurationArgs
 *                     {
 *                         IpamEnabled = "False",
 *                         NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                         PluginType = "SRIOV",
 *                     },
 *                 },
 *                 TrunkedNetworks = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.TrunkedNetworkAttachmentConfigurationArgs
 *                     {
 *                         NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName",
 *                         PluginType = "MACVLAN",
 *                     },
 *                 },
 *             },
 *             BgpServiceLoadBalancerConfiguration = new AzureNative.NetworkCloud.Inputs.BgpServiceLoadBalancerConfigurationArgs
 *             {
 *                 BgpAdvertisements = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.BgpAdvertisementArgs
 *                     {
 *                         AdvertiseToFabric = "True",
 *                         Communities = new[]
 *                         {
 *                             "64512:100",
 *                         },
 *                         IpAddressPools = new[]
 *                         {
 *                             "pool1",
 *                         },
 *                         Peers = new[]
 *                         {
 *                             "peer1",
 *                         },
 *                     },
 *                 },
 *                 BgpPeers = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.ServiceLoadBalancerBgpPeerArgs
 *                     {
 *                         BfdEnabled = "False",
 *                         BgpMultiHop = "False",
 *                         HoldTime = "P300s",
 *                         KeepAliveTime = "P300s",
 *                         MyAsn = 64512,
 *                         Name = "peer1",
 *                         PeerAddress = "203.0.113.254",
 *                         PeerAsn = 64497,
 *                         PeerPort = 179,
 *                     },
 *                 },
 *                 FabricPeeringEnabled = "True",
 *                 IpAddressPools = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.IpAddressPoolArgs
 *                     {
 *                         Addresses = new[]
 *                         {
 *                             "198.51.102.0/24",
 *                         },
 *                         AutoAssign = "True",
 *                         Name = "pool1",
 *                         OnlyUseHostIps = "True",
 *                     },
 *                 },
 *             },
 *             CloudServicesNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName",
 *             CniNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *             DnsServiceIp = "198.51.101.2",
 *             PodCidrs = new[]
 *             {
 *                 "198.51.100.0/24",
 *             },
 *             ServiceCidrs = new[]
 *             {
 *                 "198.51.101.0/24",
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := networkcloud.NewKubernetesCluster(ctx, "kubernetesCluster", &networkcloud.KubernetesClusterArgs{
 * AadConfiguration: &networkcloud.AadConfigurationArgs{
 * AdminGroupObjectIds: pulumi.StringArray{
 * pulumi.String("ffffffff-ffff-ffff-ffff-ffffffffffff"),
 * },
 * },
 * AdministratorConfiguration: networkcloud.AdministratorConfigurationResponse{
 * AdminUsername: pulumi.String("azure"),
 * SshPublicKeys: networkcloud.SshPublicKeyArray{
 * &networkcloud.SshPublicKeyArgs{
 * KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * },
 * },
 * },
 * ControlPlaneNodeConfiguration: networkcloud.ControlPlaneNodeConfigurationResponse{
 * AdministratorConfiguration: interface{}{
 * AdminUsername: pulumi.String("azure"),
 * SshPublicKeys: networkcloud.SshPublicKeyArray{
 * &networkcloud.SshPublicKeyArgs{
 * KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * },
 * },
 * },
 * AvailabilityZones: pulumi.StringArray{
 * pulumi.String("1"),
 * pulumi.String("2"),
 * pulumi.String("3"),
 * },
 * Count: pulumi.Float64(3),
 * VmSkuName: pulumi.String("NC_G4_v1"),
 * },
 * ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * InitialAgentPoolConfigurations: []networkcloud.InitialAgentPoolConfigurationArgs{
 * {
 * AdministratorConfiguration: {
 * AdminUsername: pulumi.String("azure"),
 * SshPublicKeys: networkcloud.SshPublicKeyArray{
 * {
 * KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * },
 * },
 * },
 * AgentOptions: {
 * HugepagesCount: pulumi.Float64(96),
 * HugepagesSize: pulumi.String("1G"),
 * },
 * AttachedNetworkConfiguration: {
 * L2Networks: networkcloud.L2NetworkAttachmentConfigurationArray{
 * {
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 * PluginType: pulumi.String("DPDK"),
 * },
 * },
 * L3Networks: networkcloud.L3NetworkAttachmentConfigurationArray{
 * {
 * IpamEnabled: pulumi.String("False"),
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * PluginType: pulumi.String("SRIOV"),
 * },
 * },
 * TrunkedNetworks: networkcloud.TrunkedNetworkAttachmentConfigurationArray{
 * {
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 * PluginType: pulumi.String("MACVLAN"),
 * },
 * },
 * },
 * AvailabilityZones: pulumi.StringArray{
 * pulumi.String("1"),
 * pulumi.String("2"),
 * pulumi.String("3"),
 * },
 * Count: pulumi.Float64(3),
 * Labels: networkcloud.KubernetesLabelArray{
 * {
 * Key: pulumi.String("kubernetes.label"),
 * Value: pulumi.String("true"),
 * },
 * },
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("SystemPool-1"),
 * Taints: networkcloud.KubernetesLabelArray{
 * {
 * Key: pulumi.String("kubernetes.taint"),
 * Value: pulumi.String("true"),
 * },
 * },
 * UpgradeSettings: {
 * MaxSurge: pulumi.String("1"),
 * },
 * VmSkuName: pulumi.String("NC_M16_v1"),
 * },
 * },
 * KubernetesClusterName: pulumi.String("kubernetesClusterName"),
 * KubernetesVersion: pulumi.String("1.24.12-1"),
 * Location: pulumi.String("location"),
 * ManagedResourceGroupConfiguration: &networkcloud.ManagedResourceGroupConfigurationArgs{
 * Location: pulumi.String("East US"),
 * Name: pulumi.String("my-managed-rg"),
 * },
 * NetworkConfiguration: networkcloud.NetworkConfigurationResponse{
 * AttachedNetworkConfiguration: interface{}{
 * L2Networks: networkcloud.L2NetworkAttachmentConfigurationArray{
 * &networkcloud.L2NetworkAttachmentConfigurationArgs{
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 * PluginType: pulumi.String("DPDK"),
 * },
 * },
 * L3Networks: networkcloud.L3NetworkAttachmentConfigurationArray{
 * &networkcloud.L3NetworkAttachmentConfigurationArgs{
 * IpamEnabled: pulumi.String("False"),
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * PluginType: pulumi.String("SRIOV"),
 * },
 * },
 * TrunkedNetworks: networkcloud.TrunkedNetworkAttachmentConfigurationArray{
 * &networkcloud.TrunkedNetworkAttachmentConfigurationArgs{
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 * PluginType: pulumi.String("MACVLAN"),
 * },
 * },
 * },
 * BgpServiceLoadBalancerConfiguration: interface{}{
 * BgpAdvertisements: networkcloud.BgpAdvertisementArray{
 * &networkcloud.BgpAdvertisementArgs{
 * AdvertiseToFabric: pulumi.String("True"),
 * Communities: pulumi.StringArray{
 * pulumi.String("64512:100"),
 * },
 * IpAddressPools: pulumi.StringArray{
 * pulumi.String("pool1"),
 * },
 * Peers: pulumi.StringArray{
 * pulumi.String("peer1"),
 * },
 * },
 * },
 * BgpPeers: networkcloud.ServiceLoadBalancerBgpPeerArray{
 * &networkcloud.ServiceLoadBalancerBgpPeerArgs{
 * BfdEnabled: pulumi.String("False"),
 * BgpMultiHop: pulumi.String("False"),
 * HoldTime: pulumi.String("P300s"),
 * KeepAliveTime: pulumi.String("P300s"),
 * MyAsn: pulumi.Float64(64512),
 * Name: pulumi.String("peer1"),
 * PeerAddress: pulumi.String("203.0.113.254"),
 * PeerAsn: pulumi.Float64(64497),
 * PeerPort: pulumi.Float64(179),
 * },
 * },
 * FabricPeeringEnabled: pulumi.String("True"),
 * IpAddressPools: networkcloud.IpAddressPoolArray{
 * &networkcloud.IpAddressPoolArgs{
 * Addresses: pulumi.StringArray{
 * pulumi.String("198.51.102.0/24"),
 * },
 * AutoAssign: pulumi.String("True"),
 * Name: pulumi.String("pool1"),
 * OnlyUseHostIps: pulumi.String("True"),
 * },
 * },
 * },
 * CloudServicesNetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
 * CniNetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * DnsServiceIp: pulumi.String("198.51.101.2"),
 * PodCidrs: pulumi.StringArray{
 * pulumi.String("198.51.100.0/24"),
 * },
 * ServiceCidrs: pulumi.StringArray{
 * pulumi.String("198.51.101.0/24"),
 * },
 * },
 * ResourceGroupName: pulumi.String("resourceGroupName"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("myvalue1"),
 * "key2": pulumi.String("myvalue2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.KubernetesCluster;
 * import com.pulumi.azurenative.networkcloud.KubernetesClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kubernetesCluster = new KubernetesCluster("kubernetesCluster", KubernetesClusterArgs.builder()
 *             .aadConfiguration(Map.of("adminGroupObjectIds", "ffffffff-ffff-ffff-ffff-ffffffffffff"))
 *             .administratorConfiguration(Map.ofEntries(
 *                 Map.entry("adminUsername", "azure"),
 *                 Map.entry("sshPublicKeys", Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *             ))
 *             .controlPlaneNodeConfiguration(Map.ofEntries(
 *                 Map.entry("administratorConfiguration", Map.ofEntries(
 *                     Map.entry("adminUsername", "azure"),
 *                     Map.entry("sshPublicKeys", Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *                 )),
 *                 Map.entry("availabilityZones",
 *                     "1",
 *                     "2",
 *                     "3"),
 *                 Map.entry("count", 3),
 *                 Map.entry("vmSkuName", "NC_G4_v1")
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .initialAgentPoolConfigurations(Map.ofEntries(
 *                 Map.entry("administratorConfiguration", Map.ofEntries(
 *                     Map.entry("adminUsername", "azure"),
 *                     Map.entry("sshPublicKeys", Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *                 )),
 *                 Map.entry("agentOptions", Map.ofEntries(
 *                     Map.entry("hugepagesCount", 96),
 *                     Map.entry("hugepagesSize", "1G")
 *                 )),
 *                 Map.entry("attachedNetworkConfiguration", Map.ofEntries(
 *                     Map.entry("l2Networks", Map.ofEntries(
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 *                         Map.entry("pluginType", "DPDK")
 *                     )),
 *                     Map.entry("l3Networks", Map.ofEntries(
 *                         Map.entry("ipamEnabled", "False"),
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 *                         Map.entry("pluginType", "SRIOV")
 *                     )),
 *                     Map.entry("trunkedNetworks", Map.ofEntries(
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 *                         Map.entry("pluginType", "MACVLAN")
 *                     ))
 *                 )),
 *                 Map.entry("availabilityZones",
 *                     "1",
 *                     "2",
 *                     "3"),
 *                 Map.entry("count", 3),
 *                 Map.entry("labels", Map.ofEntries(
 *                     Map.entry("key", "kubernetes.label"),
 *                     Map.entry("value", "true")
 *                 )),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "SystemPool-1"),
 *                 Map.entry("taints", Map.ofEntries(
 *                     Map.entry("key", "kubernetes.taint"),
 *                     Map.entry("value", "true")
 *                 )),
 *                 Map.entry("upgradeSettings", Map.of("maxSurge", "1")),
 *                 Map.entry("vmSkuName", "NC_M16_v1")
 *             ))
 *             .kubernetesClusterName("kubernetesClusterName")
 *             .kubernetesVersion("1.24.12-1")
 *             .location("location")
 *             .managedResourceGroupConfiguration(Map.ofEntries(
 *                 Map.entry("location", "East US"),
 *                 Map.entry("name", "my-managed-rg")
 *             ))
 *             .networkConfiguration(Map.ofEntries(
 *                 Map.entry("attachedNetworkConfiguration", Map.ofEntries(
 *                     Map.entry("l2Networks", Map.ofEntries(
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 *                         Map.entry("pluginType", "DPDK")
 *                     )),
 *                     Map.entry("l3Networks", Map.ofEntries(
 *                         Map.entry("ipamEnabled", "False"),
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 *                         Map.entry("pluginType", "SRIOV")
 *                     )),
 *                     Map.entry("trunkedNetworks", Map.ofEntries(
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 *                         Map.entry("pluginType", "MACVLAN")
 *                     ))
 *                 )),
 *                 Map.entry("bgpServiceLoadBalancerConfiguration", Map.ofEntries(
 *                     Map.entry("bgpAdvertisements", Map.ofEntries(
 *                         Map.entry("advertiseToFabric", "True"),
 *                         Map.entry("communities", "64512:100"),
 *                         Map.entry("ipAddressPools", "pool1"),
 *                         Map.entry("peers", "peer1")
 *                     )),
 *                     Map.entry("bgpPeers", Map.ofEntries(
 *                         Map.entry("bfdEnabled", "False"),
 *                         Map.entry("bgpMultiHop", "False"),
 *                         Map.entry("holdTime", "P300s"),
 *                         Map.entry("keepAliveTime", "P300s"),
 *                         Map.entry("myAsn", 64512),
 *                         Map.entry("name", "peer1"),
 *                         Map.entry("peerAddress", "203.0.113.254"),
 *                         Map.entry("peerAsn", 64497),
 *                         Map.entry("peerPort", 179)
 *                     )),
 *                     Map.entry("fabricPeeringEnabled", "True"),
 *                     Map.entry("ipAddressPools", Map.ofEntries(
 *                         Map.entry("addresses", "198.51.102.0/24"),
 *                         Map.entry("autoAssign", "True"),
 *                         Map.entry("name", "pool1"),
 *                         Map.entry("onlyUseHostIps", "True")
 *                     ))
 *                 )),
 *                 Map.entry("cloudServicesNetworkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
 *                 Map.entry("cniNetworkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 *                 Map.entry("dnsServiceIp", "198.51.101.2"),
 *                 Map.entry("podCidrs", "198.51.100.0/24"),
 *                 Map.entry("serviceCidrs", "198.51.101.0/24")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:KubernetesCluster KubernetesClusterName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}
 * ```
 * @property aadConfiguration The Azure Active Directory Integration properties.
 * @property administratorConfiguration The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
 * @property controlPlaneNodeConfiguration The defining characteristics of the control plane for this Kubernetes Cluster.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property initialAgentPoolConfigurations The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
 * @property kubernetesClusterName The name of the Kubernetes cluster.
 * @property kubernetesVersion The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used will be resolved into this field after creation or update.
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration The configuration of the managed resource group associated with the resource.
 * @property networkConfiguration The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class KubernetesClusterArgs(
    public val aadConfiguration: Output<AadConfigurationArgs>? = null,
    public val administratorConfiguration: Output<AdministratorConfigurationArgs>? = null,
    public val controlPlaneNodeConfiguration: Output<ControlPlaneNodeConfigurationArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val initialAgentPoolConfigurations: Output<List<InitialAgentPoolConfigurationArgs>>? =
        null,
    public val kubernetesClusterName: Output<String>? = null,
    public val kubernetesVersion: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null,
    public val networkConfiguration: Output<NetworkConfigurationArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.KubernetesClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.KubernetesClusterArgs =
        com.pulumi.azurenative.networkcloud.KubernetesClusterArgs.builder()
            .aadConfiguration(aadConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .administratorConfiguration(
                administratorConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .controlPlaneNodeConfiguration(
                controlPlaneNodeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .initialAgentPoolConfigurations(
                initialAgentPoolConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .kubernetesClusterName(kubernetesClusterName?.applyValue({ args0 -> args0 }))
            .kubernetesVersion(kubernetesVersion?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedResourceGroupConfiguration(
                managedResourceGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KubernetesClusterArgs].
 */
@PulumiTagMarker
public class KubernetesClusterArgsBuilder internal constructor() {
    private var aadConfiguration: Output<AadConfigurationArgs>? = null

    private var administratorConfiguration: Output<AdministratorConfigurationArgs>? = null

    private var controlPlaneNodeConfiguration: Output<ControlPlaneNodeConfigurationArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var initialAgentPoolConfigurations: Output<List<InitialAgentPoolConfigurationArgs>>? =
        null

    private var kubernetesClusterName: Output<String>? = null

    private var kubernetesVersion: Output<String>? = null

    private var location: Output<String>? = null

    private var managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null

    private var networkConfiguration: Output<NetworkConfigurationArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Azure Active Directory Integration properties.
     */
    @JvmName("esunspyesxtqeaid")
    public suspend fun aadConfiguration(`value`: Output<AadConfigurationArgs>) {
        this.aadConfiguration = value
    }

    /**
     * @param value The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
     */
    @JvmName("hddaeqgovggrdguj")
    public suspend fun administratorConfiguration(`value`: Output<AdministratorConfigurationArgs>) {
        this.administratorConfiguration = value
    }

    /**
     * @param value The defining characteristics of the control plane for this Kubernetes Cluster.
     */
    @JvmName("owmroekbhljgxhkq")
    public suspend
    fun controlPlaneNodeConfiguration(`value`: Output<ControlPlaneNodeConfigurationArgs>) {
        this.controlPlaneNodeConfiguration = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("qsuswtbivaiybihu")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("vklsfmhiptsqnnce")
    public suspend
    fun initialAgentPoolConfigurations(`value`: Output<List<InitialAgentPoolConfigurationArgs>>) {
        this.initialAgentPoolConfigurations = value
    }

    @JvmName("fwljkrnsxdrerljd")
    public suspend fun initialAgentPoolConfigurations(
        vararg
        values: Output<InitialAgentPoolConfigurationArgs>,
    ) {
        this.initialAgentPoolConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("nslvtsjylmoknbub")
    public suspend
    fun initialAgentPoolConfigurations(values: List<Output<InitialAgentPoolConfigurationArgs>>) {
        this.initialAgentPoolConfigurations = Output.all(values)
    }

    /**
     * @param value The name of the Kubernetes cluster.
     */
    @JvmName("xpcbhlskxdwdggba")
    public suspend fun kubernetesClusterName(`value`: Output<String>) {
        this.kubernetesClusterName = value
    }

    /**
     * @param value The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used will be resolved into this field after creation or update.
     */
    @JvmName("lkwuqywujgrvlcry")
    public suspend fun kubernetesVersion(`value`: Output<String>) {
        this.kubernetesVersion = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lrnplvdknbkkseed")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The configuration of the managed resource group associated with the resource.
     */
    @JvmName("juucbannxkwjdrao")
    public suspend
    fun managedResourceGroupConfiguration(`value`: Output<ManagedResourceGroupConfigurationArgs>) {
        this.managedResourceGroupConfiguration = value
    }

    /**
     * @param value The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
     */
    @JvmName("tlvhqbkxykrfqhhn")
    public suspend fun networkConfiguration(`value`: Output<NetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gralqpnxrwmfhthk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sidtunjcvregabfp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Azure Active Directory Integration properties.
     */
    @JvmName("sllmdaflbcbagcbk")
    public suspend fun aadConfiguration(`value`: AadConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadConfiguration = mapped
    }

    /**
     * @param argument The Azure Active Directory Integration properties.
     */
    @JvmName("qtevuwubyduijydp")
    public suspend fun aadConfiguration(argument: suspend AadConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AadConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aadConfiguration = mapped
    }

    /**
     * @param value The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
     */
    @JvmName("luelicgfofniywao")
    public suspend fun administratorConfiguration(`value`: AdministratorConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorConfiguration = mapped
    }

    /**
     * @param argument The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
     */
    @JvmName("ygkicybwfsspwavh")
    public suspend
    fun administratorConfiguration(argument: suspend AdministratorConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AdministratorConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administratorConfiguration = mapped
    }

    /**
     * @param value The defining characteristics of the control plane for this Kubernetes Cluster.
     */
    @JvmName("mlshlvirdvaqevft")
    public suspend fun controlPlaneNodeConfiguration(`value`: ControlPlaneNodeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlaneNodeConfiguration = mapped
    }

    /**
     * @param argument The defining characteristics of the control plane for this Kubernetes Cluster.
     */
    @JvmName("vwefhgmqaobakatg")
    public suspend
    fun controlPlaneNodeConfiguration(argument: suspend ControlPlaneNodeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ControlPlaneNodeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.controlPlaneNodeConfiguration = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("sudbqwgmqhbyugdk")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("btbwxpyixkijwott")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("tpsasbycfvnyqnlg")
    public suspend
    fun initialAgentPoolConfigurations(`value`: List<InitialAgentPoolConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param argument The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("nsgywhixyxjdhkho")
    public suspend
    fun initialAgentPoolConfigurations(argument: List<suspend InitialAgentPoolConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InitialAgentPoolConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param argument The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("uufafdwtblucsohh")
    public suspend fun initialAgentPoolConfigurations(
        vararg
        argument: suspend InitialAgentPoolConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InitialAgentPoolConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param argument The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("wriddmfpcdsgofvp")
    public suspend
    fun initialAgentPoolConfigurations(argument: suspend InitialAgentPoolConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InitialAgentPoolConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param values The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("kxpddtavshiqhyqo")
    public suspend fun initialAgentPoolConfigurations(
        vararg
        values: InitialAgentPoolConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param value The name of the Kubernetes cluster.
     */
    @JvmName("rbofsblpupychihn")
    public suspend fun kubernetesClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesClusterName = mapped
    }

    /**
     * @param value The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used will be resolved into this field after creation or update.
     */
    @JvmName("ptlspdacakkxmpmh")
    public suspend fun kubernetesVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesVersion = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mgmtjtfabyqlcngk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The configuration of the managed resource group associated with the resource.
     */
    @JvmName("nrpfveavrqdlwcwa")
    public suspend
    fun managedResourceGroupConfiguration(`value`: ManagedResourceGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param argument The configuration of the managed resource group associated with the resource.
     */
    @JvmName("jvcjfmwptvredcka")
    public suspend
    fun managedResourceGroupConfiguration(argument: suspend ManagedResourceGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedResourceGroupConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param value The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
     */
    @JvmName("sgwgfnmhauojoohh")
    public suspend fun networkConfiguration(`value`: NetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
     */
    @JvmName("mqkajhltgetunsgs")
    public suspend
    fun networkConfiguration(argument: suspend NetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gafmiebbuhogfufg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("erlfckjrgjsedxdg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ovlsbkmcsifpsjtv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KubernetesClusterArgs = KubernetesClusterArgs(
        aadConfiguration = aadConfiguration,
        administratorConfiguration = administratorConfiguration,
        controlPlaneNodeConfiguration = controlPlaneNodeConfiguration,
        extendedLocation = extendedLocation,
        initialAgentPoolConfigurations = initialAgentPoolConfigurations,
        kubernetesClusterName = kubernetesClusterName,
        kubernetesVersion = kubernetesVersion,
        location = location,
        managedResourceGroupConfiguration = managedResourceGroupConfiguration,
        networkConfiguration = networkConfiguration,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
