@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministrativeCredentialsResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministrativeCredentialsResponse.Companion.toKotlin as administrativeCredentialsResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StorageAppliance].
 */
@PulumiTagMarker
public class StorageApplianceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageApplianceArgs = StorageApplianceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageApplianceArgsBuilder.() -> Unit) {
        val builder = StorageApplianceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StorageAppliance {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.StorageAppliance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageAppliance(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update storage appliance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAppliance = new AzureNative.NetworkCloud.StorageAppliance("storageAppliance", new()
 *     {
 *         AdministratorCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *         {
 *             Password = "{password}",
 *             Username = "adminUser",
 *         },
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         RackId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName",
 *         RackSlot = 1,
 *         ResourceGroupName = "resourceGroupName",
 *         SerialNumber = "BM1219XXX",
 *         StorageApplianceName = "storageApplianceName",
 *         StorageApplianceSkuId = "684E-3B16-399E",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewStorageAppliance(ctx, "storageAppliance", &networkcloud.StorageApplianceArgs{
 * 			AdministratorCredentials: &networkcloud.AdministrativeCredentialsArgs{
 * 				Password: pulumi.String("{password}"),
 * 				Username: pulumi.String("adminUser"),
 * 			},
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:              pulumi.String("location"),
 * 			RackId:                pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
 * 			RackSlot:              pulumi.Float64(1),
 * 			ResourceGroupName:     pulumi.String("resourceGroupName"),
 * 			SerialNumber:          pulumi.String("BM1219XXX"),
 * 			StorageApplianceName:  pulumi.String("storageApplianceName"),
 * 			StorageApplianceSkuId: pulumi.String("684E-3B16-399E"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.StorageAppliance;
 * import com.pulumi.azurenative.networkcloud.StorageApplianceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAppliance = new StorageAppliance("storageAppliance", StorageApplianceArgs.builder()
 *             .administratorCredentials(Map.ofEntries(
 *                 Map.entry("password", "{password}"),
 *                 Map.entry("username", "adminUser")
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("location")
 *             .rackId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName")
 *             .rackSlot(1)
 *             .resourceGroupName("resourceGroupName")
 *             .serialNumber("BM1219XXX")
 *             .storageApplianceName("storageApplianceName")
 *             .storageApplianceSkuId("684E-3B16-399E")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:StorageAppliance storageApplianceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/storageAppliances/{storageApplianceName}
 * ```
 */
public class StorageAppliance internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.StorageAppliance,
) : KotlinCustomResource(javaResource, StorageApplianceMapper) {
    /**
     * The credentials of the administrative interface on this storage appliance.
     */
    public val administratorCredentials: Output<AdministrativeCredentialsResponse>
        get() = javaResource.administratorCredentials().applyValue({ args0 ->
            args0.let({ args0 ->
                administrativeCredentialsResponseToKotlin(args0)
            })
        })

    /**
     * The total capacity of the storage appliance.
     */
    public val capacity: Output<Double>
        get() = javaResource.capacity().applyValue({ args0 -> args0 })

    /**
     * The amount of storage consumed.
     */
    public val capacityUsed: Output<Double>
        get() = javaResource.capacityUsed().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the cluster this storage appliance is associated with.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The detailed status of the storage appliance.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The endpoint for the management interface of the storage appliance.
     */
    public val managementIpv4Address: Output<String>
        get() = javaResource.managementIpv4Address().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the storage appliance.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the rack where this storage appliance resides.
     */
    public val rackId: Output<String>
        get() = javaResource.rackId().applyValue({ args0 -> args0 })

    /**
     * The slot the storage appliance is in the rack based on the BOM configuration.
     */
    public val rackSlot: Output<Double>
        get() = javaResource.rackSlot().applyValue({ args0 -> args0 })

    /**
     * The indicator of whether the storage appliance supports remote vendor management.
     */
    public val remoteVendorManagementFeature: Output<String>
        get() = javaResource.remoteVendorManagementFeature().applyValue({ args0 -> args0 })

    /**
     * The indicator of whether the remote vendor management feature is enabled or disabled, or unsupported if it is an unsupported feature.
     */
    public val remoteVendorManagementStatus: Output<String>
        get() = javaResource.remoteVendorManagementStatus().applyValue({ args0 -> args0 })

    /**
     * The serial number for the storage appliance.
     */
    public val serialNumber: Output<String>
        get() = javaResource.serialNumber().applyValue({ args0 -> args0 })

    /**
     * The SKU for the storage appliance.
     */
    public val storageApplianceSkuId: Output<String>
        get() = javaResource.storageApplianceSkuId().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StorageApplianceMapper : ResourceMapper<StorageAppliance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.StorageAppliance::class == javaResource::class

    override fun map(javaResource: Resource): StorageAppliance = StorageAppliance(
        javaResource as
            com.pulumi.azurenative.networkcloud.StorageAppliance,
    )
}

/**
 * @see [StorageAppliance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageAppliance].
 */
public suspend fun storageAppliance(
    name: String,
    block: suspend StorageApplianceResourceBuilder.() -> Unit,
): StorageAppliance {
    val builder = StorageApplianceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageAppliance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageAppliance(name: String): StorageAppliance {
    val builder = StorageApplianceResourceBuilder()
    builder.name(name)
    return builder.build()
}
