@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.TrunkedNetworkArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.HybridAksPluginType
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update trunked network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trunkedNetwork = new AzureNative.NetworkCloud.TrunkedNetwork("trunkedNetwork", new()
 *     {
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         InterfaceName = "eth0",
 *         IsolationDomainIds = new[]
 *         {
 *             "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/l2IsolationDomainName",
 *             "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName",
 *         },
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         TrunkedNetworkName = "trunkedNetworkName",
 *         Vlans = new[]
 *         {
 *             12,
 *             14,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewTrunkedNetwork(ctx, "trunkedNetwork", &networkcloud.TrunkedNetworkArgs{
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			InterfaceName: pulumi.String("eth0"),
 * 			IsolationDomainIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/l2IsolationDomainName"),
 * 				pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			TrunkedNetworkName: pulumi.String("trunkedNetworkName"),
 * 			Vlans: pulumi.Float64Array{
 * 				pulumi.Float64(12),
 * 				pulumi.Float64(14),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.TrunkedNetwork;
 * import com.pulumi.azurenative.networkcloud.TrunkedNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trunkedNetwork = new TrunkedNetwork("trunkedNetwork", TrunkedNetworkArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .interfaceName("eth0")
 *             .isolationDomainIds(
 *                 "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/l2IsolationDomainName",
 *                 "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName")
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .trunkedNetworkName("trunkedNetworkName")
 *             .vlans(
 *                 12,
 *                 14)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:TrunkedNetwork trunkedNetworkName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/trunkedNetworks/{trunkedNetworkName}
 * ```
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property hybridAksPluginType Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
 * @property interfaceName The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
 * @property isolationDomainIds The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property trunkedNetworkName The name of the trunked network.
 * @property vlans The list of vlans that are selected from the isolation domains for trunking.
 */
public data class TrunkedNetworkArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hybridAksPluginType: Output<Either<String, HybridAksPluginType>>? = null,
    public val interfaceName: Output<String>? = null,
    public val isolationDomainIds: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trunkedNetworkName: Output<String>? = null,
    public val vlans: Output<List<Double>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.TrunkedNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.TrunkedNetworkArgs =
        com.pulumi.azurenative.networkcloud.TrunkedNetworkArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hybridAksPluginType(
                hybridAksPluginType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .interfaceName(interfaceName?.applyValue({ args0 -> args0 }))
            .isolationDomainIds(isolationDomainIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trunkedNetworkName(trunkedNetworkName?.applyValue({ args0 -> args0 }))
            .vlans(vlans?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TrunkedNetworkArgs].
 */
@PulumiTagMarker
public class TrunkedNetworkArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hybridAksPluginType: Output<Either<String, HybridAksPluginType>>? = null

    private var interfaceName: Output<String>? = null

    private var isolationDomainIds: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trunkedNetworkName: Output<String>? = null

    private var vlans: Output<List<Double>>? = null

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("brfhlahokuqjkfel")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("khotecllykmmhkwx")
    public suspend fun hybridAksPluginType(`value`: Output<Either<String, HybridAksPluginType>>) {
        this.hybridAksPluginType = value
    }

    /**
     * @param value The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
     */
    @JvmName("xkxdgcuvcoputgmr")
    public suspend fun interfaceName(`value`: Output<String>) {
        this.interfaceName = value
    }

    /**
     * @param value The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
     */
    @JvmName("ietwmnidfuglarmx")
    public suspend fun isolationDomainIds(`value`: Output<List<String>>) {
        this.isolationDomainIds = value
    }

    @JvmName("qwxcbqjuhvnwghyo")
    public suspend fun isolationDomainIds(vararg values: Output<String>) {
        this.isolationDomainIds = Output.all(values.asList())
    }

    /**
     * @param values The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
     */
    @JvmName("efuyvtmpjwvdvjod")
    public suspend fun isolationDomainIds(values: List<Output<String>>) {
        this.isolationDomainIds = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("twtkxvnpvnjmiqwr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ixkmvnqrygfhsxjc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ggjamjmcwfmsmpac")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the trunked network.
     */
    @JvmName("rysiumdtldoxeymi")
    public suspend fun trunkedNetworkName(`value`: Output<String>) {
        this.trunkedNetworkName = value
    }

    /**
     * @param value The list of vlans that are selected from the isolation domains for trunking.
     */
    @JvmName("jauygnvkmlnyemqw")
    public suspend fun vlans(`value`: Output<List<Double>>) {
        this.vlans = value
    }

    @JvmName("lduqavofglhkvnjd")
    public suspend fun vlans(vararg values: Output<Double>) {
        this.vlans = Output.all(values.asList())
    }

    /**
     * @param values The list of vlans that are selected from the isolation domains for trunking.
     */
    @JvmName("iviystkmqydcokbu")
    public suspend fun vlans(values: List<Output<Double>>) {
        this.vlans = Output.all(values)
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("tmmcsjthyamuiqtl")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("adaggerpegstgoxw")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("kihpjuhdjoxndwxc")
    public suspend fun hybridAksPluginType(`value`: Either<String, HybridAksPluginType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridAksPluginType = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("egrxyktjamuxwrpp")
    public fun hybridAksPluginType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HybridAksPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hybridAksPluginType = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("xdisownreqpvsioe")
    public fun hybridAksPluginType(`value`: HybridAksPluginType) {
        val toBeMapped = Either.ofRight<String, HybridAksPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hybridAksPluginType = mapped
    }

    /**
     * @param value The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
     */
    @JvmName("gsfvcfwdvmiwvcoc")
    public suspend fun interfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interfaceName = mapped
    }

    /**
     * @param value The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
     */
    @JvmName("bmldkhobiviwqtsk")
    public suspend fun isolationDomainIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isolationDomainIds = mapped
    }

    /**
     * @param values The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
     */
    @JvmName("tfnficaqgdukvvlq")
    public suspend fun isolationDomainIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isolationDomainIds = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dcfhvrwnonlhogdq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pxidimodcjvjblit")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vkeugriwcvgmnrgq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kfwfdrdpuphpynvd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the trunked network.
     */
    @JvmName("cnyrveeldgstkcvw")
    public suspend fun trunkedNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trunkedNetworkName = mapped
    }

    /**
     * @param value The list of vlans that are selected from the isolation domains for trunking.
     */
    @JvmName("tjgvtdikimjwoihk")
    public suspend fun vlans(`value`: List<Double>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlans = mapped
    }

    /**
     * @param values The list of vlans that are selected from the isolation domains for trunking.
     */
    @JvmName("ebywdqauevdipcar")
    public suspend fun vlans(vararg values: Double) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vlans = mapped
    }

    internal fun build(): TrunkedNetworkArgs = TrunkedNetworkArgs(
        extendedLocation = extendedLocation,
        hybridAksPluginType = hybridAksPluginType,
        interfaceName = interfaceName,
        isolationDomainIds = isolationDomainIds,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        trunkedNetworkName = trunkedNetworkName,
        vlans = vlans,
    )
}
