@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ImageRepositoryCredentialsResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.NetworkAttachmentResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SshPublicKeyResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.StorageProfileResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.VirtualMachinePlacementHintResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ImageRepositoryCredentialsResponse.Companion.toKotlin as imageRepositoryCredentialsResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.NetworkAttachmentResponse.Companion.toKotlin as networkAttachmentResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin as sshPublicKeyResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.StorageProfileResponse.Companion.toKotlin as storageProfileResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.VirtualMachinePlacementHintResponse.Companion.toKotlin as virtualMachinePlacementHintResponseToKotlin

/**
 * Builder for [VirtualMachine].
 */
@PulumiTagMarker
public class VirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineArgs = VirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineArgsBuilder.() -> Unit) {
        val builder = VirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualMachine {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.VirtualMachine(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachine(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update virtual machine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.NetworkCloud.VirtualMachine("virtualMachine", new()
 *     {
 *         AdminUsername = "username",
 *         BootMethod = "UEFI",
 *         CloudServicesNetworkAttachment = new AzureNative.NetworkCloud.Inputs.NetworkAttachmentArgs
 *         {
 *             AttachedNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName",
 *             IpAllocationMethod = "Dynamic",
 *         },
 *         CpuCores = 2,
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         MemorySizeGB = 8,
 *         NetworkAttachments = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.NetworkAttachmentArgs
 *             {
 *                 AttachedNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                 DefaultGateway = "True",
 *                 IpAllocationMethod = "Dynamic",
 *                 Ipv4Address = "198.51.100.1",
 *                 Ipv6Address = "2001:0db8:0000:0000:0000:0000:0000:0000",
 *                 NetworkAttachmentName = "netAttachName01",
 *             },
 *         },
 *         NetworkData = "bmV0d29ya0RhdGVTYW1wbGU=",
 *         PlacementHints = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.VirtualMachinePlacementHintArgs
 *             {
 *                 HintType = "Affinity",
 *                 ResourceId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName",
 *                 SchedulingExecution = "Hard",
 *                 Scope = "",
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         SshPublicKeys = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *             {
 *                 KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *             },
 *         },
 *         StorageProfile = new AzureNative.NetworkCloud.Inputs.StorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.NetworkCloud.Inputs.OsDiskArgs
 *             {
 *                 CreateOption = "Ephemeral",
 *                 DeleteOption = "Delete",
 *                 DiskSizeGB = 120,
 *             },
 *             VolumeAttachments = new[]
 *             {
 *                 "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         UserData = "dXNlckRhdGVTYW1wbGU=",
 *         VirtualMachineName = "virtualMachineName",
 *         VmDeviceModel = "T2",
 *         VmImage = "myacr.azurecr.io/foobar:latest",
 *         VmImageRepositoryCredentials = new AzureNative.NetworkCloud.Inputs.ImageRepositoryCredentialsArgs
 *         {
 *             Password = "{password}",
 *             RegistryUrl = "myacr.azurecr.io",
 *             Username = "myuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewVirtualMachine(ctx, "virtualMachine", &networkcloud.VirtualMachineArgs{
 * 			AdminUsername: pulumi.String("username"),
 * 			BootMethod:    pulumi.String("UEFI"),
 * 			CloudServicesNetworkAttachment: &networkcloud.NetworkAttachmentArgs{
 * 				AttachedNetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
 * 				IpAllocationMethod: pulumi.String("Dynamic"),
 * 			},
 * 			CpuCores: pulumi.Float64(2),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:     pulumi.String("location"),
 * 			MemorySizeGB: pulumi.Float64(8),
 * 			NetworkAttachments: []networkcloud.NetworkAttachmentArgs{
 * 				{
 * 					AttachedNetworkId:     pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * 					DefaultGateway:        pulumi.String("True"),
 * 					IpAllocationMethod:    pulumi.String("Dynamic"),
 * 					Ipv4Address:           pulumi.String("198.51.100.1"),
 * 					Ipv6Address:           pulumi.String("2001:0db8:0000:0000:0000:0000:0000:0000"),
 * 					NetworkAttachmentName: pulumi.String("netAttachName01"),
 * 				},
 * 			},
 * 			NetworkData: pulumi.String("bmV0d29ya0RhdGVTYW1wbGU="),
 * 			PlacementHints: []networkcloud.VirtualMachinePlacementHintArgs{
 * 				{
 * 					HintType:            pulumi.String("Affinity"),
 * 					ResourceId:          pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
 * 					SchedulingExecution: pulumi.String("Hard"),
 * 					Scope:               pulumi.String(""),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SshPublicKeys: []networkcloud.SshPublicKeyArgs{
 * 				{
 * 					KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 				},
 * 			},
 * 			StorageProfile: networkcloud.StorageProfileResponse{
 * 				OsDisk: &networkcloud.OsDiskArgs{
 * 					CreateOption: pulumi.String("Ephemeral"),
 * 					DeleteOption: pulumi.String("Delete"),
 * 					DiskSizeGB:   pulumi.Float64(120),
 * 				},
 * 				VolumeAttachments: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			UserData:           pulumi.String("dXNlckRhdGVTYW1wbGU="),
 * 			VirtualMachineName: pulumi.String("virtualMachineName"),
 * 			VmDeviceModel:      pulumi.String("T2"),
 * 			VmImage:            pulumi.String("myacr.azurecr.io/foobar:latest"),
 * 			VmImageRepositoryCredentials: &networkcloud.ImageRepositoryCredentialsArgs{
 * 				Password:    pulumi.String("{password}"),
 * 				RegistryUrl: pulumi.String("myacr.azurecr.io"),
 * 				Username:    pulumi.String("myuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.VirtualMachine;
 * import com.pulumi.azurenative.networkcloud.VirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .adminUsername("username")
 *             .bootMethod("UEFI")
 *             .cloudServicesNetworkAttachment(Map.ofEntries(
 *                 Map.entry("attachedNetworkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
 *                 Map.entry("ipAllocationMethod", "Dynamic")
 *             ))
 *             .cpuCores(2)
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("location")
 *             .memorySizeGB(8)
 *             .networkAttachments(Map.ofEntries(
 *                 Map.entry("attachedNetworkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 *                 Map.entry("defaultGateway", "True"),
 *                 Map.entry("ipAllocationMethod", "Dynamic"),
 *                 Map.entry("ipv4Address", "198.51.100.1"),
 *                 Map.entry("ipv6Address", "2001:0db8:0000:0000:0000:0000:0000:0000"),
 *                 Map.entry("networkAttachmentName", "netAttachName01")
 *             ))
 *             .networkData("bmV0d29ya0RhdGVTYW1wbGU=")
 *             .placementHints(Map.ofEntries(
 *                 Map.entry("hintType", "Affinity"),
 *                 Map.entry("resourceId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
 *                 Map.entry("schedulingExecution", "Hard"),
 *                 Map.entry("scope", "")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .sshPublicKeys(Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *             .storageProfile(Map.ofEntries(
 *                 Map.entry("osDisk", Map.ofEntries(
 *                     Map.entry("createOption", "Ephemeral"),
 *                     Map.entry("deleteOption", "Delete"),
 *                     Map.entry("diskSizeGB", 120)
 *                 )),
 *                 Map.entry("volumeAttachments", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/volumes/volumeName")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .userData("dXNlckRhdGVTYW1wbGU=")
 *             .virtualMachineName("virtualMachineName")
 *             .vmDeviceModel("T2")
 *             .vmImage("myacr.azurecr.io/foobar:latest")
 *             .vmImageRepositoryCredentials(Map.ofEntries(
 *                 Map.entry("password", "{password}"),
 *                 Map.entry("registryUrl", "myacr.azurecr.io"),
 *                 Map.entry("username", "myuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:VirtualMachine virtualMachineName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}
 * ```
 */
public class VirtualMachine internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.VirtualMachine,
) : KotlinCustomResource(javaResource, VirtualMachineMapper) {
    /**
     * The name of the administrator to which the ssh public keys will be added into the authorized keys.
     */
    public val adminUsername: Output<String>
        get() = javaResource.adminUsername().applyValue({ args0 -> args0 })

    /**
     * The cluster availability zone containing this virtual machine.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the bare metal machine the virtual machine has landed to.
     */
    public val bareMetalMachineId: Output<String>
        get() = javaResource.bareMetalMachineId().applyValue({ args0 -> args0 })

    /**
     * Selects the boot method for the virtual machine.
     */
    public val bootMethod: Output<String>?
        get() = javaResource.bootMethod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The cloud service network that provides platform-level services for the virtual machine.
     */
    public val cloudServicesNetworkAttachment: Output<NetworkAttachmentResponse>
        get() = javaResource.cloudServicesNetworkAttachment().applyValue({ args0 ->
            args0.let({ args0 ->
                networkAttachmentResponseToKotlin(args0)
            })
        })

    /**
     * The resource ID of the cluster the virtual machine is created for.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The number of CPU cores in the virtual machine.
     */
    public val cpuCores: Output<Double>
        get() = javaResource.cpuCores().applyValue({ args0 -> args0 })

    /**
     * The more detailed status of the virtual machine.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
     */
    public val isolateEmulatorThread: Output<String>?
        get() = javaResource.isolateEmulatorThread().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The memory size of the virtual machine in GB.
     */
    public val memorySizeGB: Output<Double>
        get() = javaResource.memorySizeGB().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of network attachments to the virtual machine.
     */
    public val networkAttachments: Output<List<NetworkAttachmentResponse>>?
        get() = javaResource.networkAttachments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        networkAttachmentResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The Base64 encoded cloud-init network data.
     */
    public val networkData: Output<String>?
        get() = javaResource.networkData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The scheduling hints for the virtual machine.
     */
    public val placementHints: Output<List<VirtualMachinePlacementHintResponse>>?
        get() = javaResource.placementHints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        virtualMachinePlacementHintResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The power state of the virtual machine.
     */
    public val powerState: Output<String>
        get() = javaResource.powerState().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the virtual machine.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
     */
    public val sshPublicKeys: Output<List<SshPublicKeyResponse>>?
        get() = javaResource.sshPublicKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        sshPublicKeyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The storage profile that specifies size and other parameters about the disks related to the virtual machine.
     */
    public val storageProfile: Output<StorageProfileResponse>
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                storageProfileResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The Base64 encoded cloud-init user data.
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
     */
    public val virtioInterface: Output<String>?
        get() = javaResource.virtioInterface().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the device model to use.
     */
    public val vmDeviceModel: Output<String>?
        get() = javaResource.vmDeviceModel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used to pull the image.
     */
    public val vmImage: Output<String>
        get() = javaResource.vmImage().applyValue({ args0 -> args0 })

    /**
     * The credentials used to login to the image repository that has access to the specified image.
     */
    public val vmImageRepositoryCredentials: Output<ImageRepositoryCredentialsResponse>?
        get() = javaResource.vmImageRepositoryCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> imageRepositoryCredentialsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The resource IDs of volumes that are attached to the virtual machine.
     */
    public val volumes: Output<List<String>>
        get() = javaResource.volumes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object VirtualMachineMapper : ResourceMapper<VirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.VirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachine = VirtualMachine(
        javaResource as
            com.pulumi.azurenative.networkcloud.VirtualMachine,
    )
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachine].
 */
public suspend fun virtualMachine(
    name: String,
    block: suspend VirtualMachineResourceBuilder.() -> Unit,
): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachine(name: String): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
