@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The indicator of whether this is the default gateway.
 * Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
 */
public enum class DefaultGateway(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.DefaultGateway,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.DefaultGateway> {
    True(com.pulumi.azurenative.networkcloud.enums.DefaultGateway.True),
    False(com.pulumi.azurenative.networkcloud.enums.DefaultGateway.False),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.DefaultGateway = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.DefaultGateway):
            DefaultGateway = DefaultGateway.values().first { it.javaValue == javaType }
    }
}
