@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Selects the boot method for the virtual machine.
 */
public enum class VirtualMachineBootMethod(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.VirtualMachineBootMethod,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.VirtualMachineBootMethod> {
    UEFI(com.pulumi.azurenative.networkcloud.enums.VirtualMachineBootMethod.UEFI),
    BIOS(com.pulumi.azurenative.networkcloud.enums.VirtualMachineBootMethod.BIOS),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.VirtualMachineBootMethod =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.VirtualMachineBootMethod):
            VirtualMachineBootMethod =
            VirtualMachineBootMethod.values().first { it.javaValue == javaType }
    }
}
