@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.BgpAdvertisementArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.AdvertiseToFabric
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property advertiseToFabric The indicator of if this advertisement is also made to the network fabric associated with the Network Cloud Cluster. This field is ignored if fabricPeeringEnabled is set to False.
 * @property communities The names of the BGP communities to be associated with the announcement, utilizing a BGP community string in 1234:1234 format.
 * @property ipAddressPools The names of the IP address pools associated with this announcement.
 * @property peers The names of the BGP peers to limit this advertisement to. If no values are specified, all BGP peers will receive this advertisement.
 */
public data class BgpAdvertisementArgs(
    public val advertiseToFabric: Output<Either<String, AdvertiseToFabric>>? = null,
    public val communities: Output<List<String>>? = null,
    public val ipAddressPools: Output<List<String>>,
    public val peers: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.BgpAdvertisementArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.BgpAdvertisementArgs =
        com.pulumi.azurenative.networkcloud.inputs.BgpAdvertisementArgs.builder()
            .advertiseToFabric(
                advertiseToFabric?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .communities(communities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipAddressPools(ipAddressPools.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .peers(peers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BgpAdvertisementArgs].
 */
@PulumiTagMarker
public class BgpAdvertisementArgsBuilder internal constructor() {
    private var advertiseToFabric: Output<Either<String, AdvertiseToFabric>>? = null

    private var communities: Output<List<String>>? = null

    private var ipAddressPools: Output<List<String>>? = null

    private var peers: Output<List<String>>? = null

    /**
     * @param value The indicator of if this advertisement is also made to the network fabric associated with the Network Cloud Cluster. This field is ignored if fabricPeeringEnabled is set to False.
     */
    @JvmName("nihristdiycfstsq")
    public suspend fun advertiseToFabric(`value`: Output<Either<String, AdvertiseToFabric>>) {
        this.advertiseToFabric = value
    }

    /**
     * @param value The names of the BGP communities to be associated with the announcement, utilizing a BGP community string in 1234:1234 format.
     */
    @JvmName("qkyosiifiedkhqaf")
    public suspend fun communities(`value`: Output<List<String>>) {
        this.communities = value
    }

    @JvmName("kkashtjjdidqywxl")
    public suspend fun communities(vararg values: Output<String>) {
        this.communities = Output.all(values.asList())
    }

    /**
     * @param values The names of the BGP communities to be associated with the announcement, utilizing a BGP community string in 1234:1234 format.
     */
    @JvmName("fbschybaasuvkanr")
    public suspend fun communities(values: List<Output<String>>) {
        this.communities = Output.all(values)
    }

    /**
     * @param value The names of the IP address pools associated with this announcement.
     */
    @JvmName("wvmyyrpwigolpjtp")
    public suspend fun ipAddressPools(`value`: Output<List<String>>) {
        this.ipAddressPools = value
    }

    @JvmName("nttevqqtlusabiaw")
    public suspend fun ipAddressPools(vararg values: Output<String>) {
        this.ipAddressPools = Output.all(values.asList())
    }

    /**
     * @param values The names of the IP address pools associated with this announcement.
     */
    @JvmName("stysutxikfnseilf")
    public suspend fun ipAddressPools(values: List<Output<String>>) {
        this.ipAddressPools = Output.all(values)
    }

    /**
     * @param value The names of the BGP peers to limit this advertisement to. If no values are specified, all BGP peers will receive this advertisement.
     */
    @JvmName("hrlgauplprystscu")
    public suspend fun peers(`value`: Output<List<String>>) {
        this.peers = value
    }

    @JvmName("bifpptivbihdvqfx")
    public suspend fun peers(vararg values: Output<String>) {
        this.peers = Output.all(values.asList())
    }

    /**
     * @param values The names of the BGP peers to limit this advertisement to. If no values are specified, all BGP peers will receive this advertisement.
     */
    @JvmName("gauyaojshuuuoqdh")
    public suspend fun peers(values: List<Output<String>>) {
        this.peers = Output.all(values)
    }

    /**
     * @param value The indicator of if this advertisement is also made to the network fabric associated with the Network Cloud Cluster. This field is ignored if fabricPeeringEnabled is set to False.
     */
    @JvmName("lnpsofpylxippyff")
    public suspend fun advertiseToFabric(`value`: Either<String, AdvertiseToFabric>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advertiseToFabric = mapped
    }

    /**
     * @param value The indicator of if this advertisement is also made to the network fabric associated with the Network Cloud Cluster. This field is ignored if fabricPeeringEnabled is set to False.
     */
    @JvmName("hlteslhofjywwkvg")
    public fun advertiseToFabric(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AdvertiseToFabric>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advertiseToFabric = mapped
    }

    /**
     * @param value The indicator of if this advertisement is also made to the network fabric associated with the Network Cloud Cluster. This field is ignored if fabricPeeringEnabled is set to False.
     */
    @JvmName("bjdyswagncxcsbwl")
    public fun advertiseToFabric(`value`: AdvertiseToFabric) {
        val toBeMapped = Either.ofRight<String, AdvertiseToFabric>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advertiseToFabric = mapped
    }

    /**
     * @param value The names of the BGP communities to be associated with the announcement, utilizing a BGP community string in 1234:1234 format.
     */
    @JvmName("wmhhrhamuwrtvgbx")
    public suspend fun communities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communities = mapped
    }

    /**
     * @param values The names of the BGP communities to be associated with the announcement, utilizing a BGP community string in 1234:1234 format.
     */
    @JvmName("ocsjlrjuvvbcalok")
    public suspend fun communities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.communities = mapped
    }

    /**
     * @param value The names of the IP address pools associated with this announcement.
     */
    @JvmName("jijgemfnvtcuhhoo")
    public suspend fun ipAddressPools(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressPools = mapped
    }

    /**
     * @param values The names of the IP address pools associated with this announcement.
     */
    @JvmName("igkgtncidemdwvxr")
    public suspend fun ipAddressPools(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressPools = mapped
    }

    /**
     * @param value The names of the BGP peers to limit this advertisement to. If no values are specified, all BGP peers will receive this advertisement.
     */
    @JvmName("jtqmgguggroonaby")
    public suspend fun peers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peers = mapped
    }

    /**
     * @param values The names of the BGP peers to limit this advertisement to. If no values are specified, all BGP peers will receive this advertisement.
     */
    @JvmName("wiwaqkcydeqirxde")
    public suspend fun peers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peers = mapped
    }

    internal fun build(): BgpAdvertisementArgs = BgpAdvertisementArgs(
        advertiseToFabric = advertiseToFabric,
        communities = communities,
        ipAddressPools = ipAddressPools ?: throw PulumiNullFieldException("ipAddressPools"),
        peers = peers,
    )
}
