@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetBareMetalMachineKeySetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bareMetalMachineKeySetName The name of the bare metal machine key set.
 * @property clusterName The name of the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBareMetalMachineKeySetPlainArgs(
    public val bareMetalMachineKeySetName: String,
    public val clusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetBareMetalMachineKeySetPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkcloud.inputs.GetBareMetalMachineKeySetPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetBareMetalMachineKeySetPlainArgs.builder()
            .bareMetalMachineKeySetName(bareMetalMachineKeySetName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBareMetalMachineKeySetPlainArgs].
 */
@PulumiTagMarker
public class GetBareMetalMachineKeySetPlainArgsBuilder internal constructor() {
    private var bareMetalMachineKeySetName: String? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the bare metal machine key set.
     */
    @JvmName("qodnogagwlhwmfbs")
    public suspend fun bareMetalMachineKeySetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bareMetalMachineKeySetName = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("fkmxioiweqsbswua")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rktqgfyvlqhebdtk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBareMetalMachineKeySetPlainArgs = GetBareMetalMachineKeySetPlainArgs(
        bareMetalMachineKeySetName = bareMetalMachineKeySetName ?: throw
            PulumiNullFieldException("bareMetalMachineKeySetName"),
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
