@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetBmcKeySetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bmcKeySetName The name of the baseboard management controller key set.
 * @property clusterName The name of the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBmcKeySetPlainArgs(
    public val bmcKeySetName: String,
    public val clusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetBmcKeySetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetBmcKeySetPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetBmcKeySetPlainArgs.builder()
            .bmcKeySetName(bmcKeySetName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBmcKeySetPlainArgs].
 */
@PulumiTagMarker
public class GetBmcKeySetPlainArgsBuilder internal constructor() {
    private var bmcKeySetName: String? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the baseboard management controller key set.
     */
    @JvmName("hrognqayyntefeuu")
    public suspend fun bmcKeySetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bmcKeySetName = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("curybroevgowugph")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hojocjhddaebresb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBmcKeySetPlainArgs = GetBmcKeySetPlainArgs(
        bmcKeySetName = bmcKeySetName ?: throw PulumiNullFieldException("bmcKeySetName"),
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
