@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetL3NetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property l3NetworkName The name of the L3 network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetL3NetworkPlainArgs(
    public val l3NetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetL3NetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetL3NetworkPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetL3NetworkPlainArgs.builder()
            .l3NetworkName(l3NetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetL3NetworkPlainArgs].
 */
@PulumiTagMarker
public class GetL3NetworkPlainArgsBuilder internal constructor() {
    private var l3NetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the L3 network.
     */
    @JvmName("vuscrgykpdsyssmt")
    public suspend fun l3NetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.l3NetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gqufrfvmbhkwgena")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetL3NetworkPlainArgs = GetL3NetworkPlainArgs(
        l3NetworkName = l3NetworkName ?: throw PulumiNullFieldException("l3NetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
