@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetRackPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property rackName The name of the rack.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetRackPlainArgs(
    public val rackName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetRackPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetRackPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetRackPlainArgs.builder()
            .rackName(rackName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRackPlainArgs].
 */
@PulumiTagMarker
public class GetRackPlainArgsBuilder internal constructor() {
    private var rackName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the rack.
     */
    @JvmName("etaatjpnxjildbda")
    public suspend fun rackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.rackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pxrfnkombgkpsjuu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRackPlainArgs = GetRackPlainArgs(
        rackName = rackName ?: throw PulumiNullFieldException("rackName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
